/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngines;
import org.flowable.app.rest.service.api.management.AppEngineInfoResponse;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.EngineInfo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Engine"}, description="Manage App Engine", authorizations={@Authorization(value="basicAuth")})
public class AppEngineResource {
    @ApiOperation(value="Get app engine info", tags={"Engine"}, notes="Returns a read-only view of the engine that is used in this REST-service.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the engine info is returned.")})
    @GetMapping(value={"/app-management/engine"}, produces={"application/json"})
    public AppEngineInfoResponse getEngineInfo() {
        AppEngineInfoResponse response = new AppEngineInfoResponse();
        try {
            AppEngine appEngine = AppEngines.getDefaultAppEngine();
            EngineInfo appEngineInfo = AppEngines.getAppEngineInfo((String)appEngine.getName());
            if (appEngineInfo != null) {
                response.setName(appEngineInfo.getName());
                response.setResourceUrl(appEngineInfo.getResourceUrl());
                response.setException(appEngineInfo.getException());
            } else {
                response.setName(appEngine.getName());
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error retrieving app engine info", (Throwable)e);
        }
        response.setVersion("6.3.1.0");
        return response;
    }
}

