/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.Task;
import org.flowable.cmmn.model.TaskWithFieldExtensions;

public class TaskExport
extends AbstractPlanItemDefinitionExport<Task> {
    protected static <T extends TaskWithFieldExtensions> void writeTaskFieldExtensions(T task, XMLStreamWriter xtw) throws XMLStreamException {
        if (task.getFieldExtensions().size() > 0) {
            xtw.writeStartElement("extensionElements");
            for (FieldExtension fieldExtension : task.getFieldExtensions()) {
                xtw.writeStartElement("flowable", "field", "http://flowable.org/cmmn");
                xtw.writeAttribute("name", fieldExtension.getFieldName());
                if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getStringValue())) {
                    xtw.writeStartElement("flowable", "string", "http://flowable.org/cmmn");
                    xtw.writeCData(fieldExtension.getStringValue());
                } else {
                    xtw.writeStartElement("flowable", "expression", "http://flowable.org/cmmn");
                    xtw.writeCData(fieldExtension.getExpression());
                }
                xtw.writeEndElement();
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }

    protected static <T extends Task> void writeCommonTaskAttributes(T task, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isEmpty((CharSequence)task.getBlockingExpression())) {
            if (!task.isBlocking()) {
                xtw.writeAttribute("isBlocking", "false");
            }
        } else {
            xtw.writeAttribute("isBlocking", "true");
        }
        if (task.isAsync()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "async", String.valueOf(task.isAsync()));
        }
        if (task.isExclusive()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "exclusive", String.valueOf(task.isAsync()));
        }
    }

    @Override
    protected Class<Task> getExportablePlanItemDefinitionClass() {
        return Task.class;
    }

    @Override
    protected String getPlanItemDefinitionXmlElementValue(Task planItemDefinition) {
        return "task";
    }

    @Override
    protected void writePlanItemDefinitionSpecificAttributes(Task task, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionSpecificAttributes(task, xtw);
        TaskExport.writeCommonTaskAttributes(task, xtw);
    }
}

