/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.TaskExport;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.ImplementationType;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.cmmn.model.ServiceTask;

public abstract class AbstractServiceTaskExport<T extends ServiceTask>
extends AbstractPlanItemDefinitionExport<ServiceTask> {
    @Override
    public String getPlanItemDefinitionXmlElementValue(ServiceTask serviceTask) {
        return "task";
    }

    @Override
    public void writePlanItemDefinitionSpecificAttributes(ServiceTask serviceTask, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionSpecificAttributes(serviceTask, xtw);
        TaskExport.writeCommonTaskAttributes(serviceTask, xtw);
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "type", serviceTask.getType());
        }
        switch (serviceTask.getType()) {
            case "java": {
                if (StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) {
                    if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
                        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "class", serviceTask.getImplementation());
                    } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
                        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "expression", serviceTask.getImplementation());
                    } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) {
                        xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "delegateExpression", serviceTask.getImplementation());
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) break;
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "resultVariableName", serviceTask.getResultVariableName());
                break;
            }
            case "http": {
                if (!StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) break;
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "class", serviceTask.getImplementation());
                break;
            }
            case "script": {
                if (StringUtils.isNotBlank((CharSequence)serviceTask.getImplementationType())) {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "scriptFormat", serviceTask.getImplementationType());
                }
                if (!StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) break;
                xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "resultVariableName", serviceTask.getResultVariableName());
            }
        }
    }

    @Override
    protected boolean writePlanItemDefinitionExtensionElements(CmmnModel model, ServiceTask serviceTask, boolean didWriteExtensionElement, XMLStreamWriter xtw) throws Exception {
        boolean extensionElementWritten = super.writePlanItemDefinitionExtensionElements(model, serviceTask, didWriteExtensionElement, xtw);
        return TaskExport.writeTaskFieldExtensions(serviceTask, extensionElementWritten, xtw);
    }

    @Override
    protected void writePlanItemDefinitionBody(CmmnModel model, ServiceTask serviceTask, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionBody(model, serviceTask, xtw);
    }

    public static class ScriptServiceTaskExport
    extends AbstractServiceTaskExport<ScriptServiceTask> {
        @Override
        protected Class<? extends ServiceTask> getExportablePlanItemDefinitionClass() {
            return ScriptServiceTask.class;
        }
    }

    public static class HttpServiceTaskExport
    extends AbstractServiceTaskExport<HttpServiceTask> {
        @Override
        protected Class<? extends ServiceTask> getExportablePlanItemDefinitionClass() {
            return HttpServiceTask.class;
        }
    }

    public static class ServiceTaskExport
    extends AbstractServiceTaskExport<ServiceTask> {
        @Override
        protected Class<? extends ServiceTask> getExportablePlanItemDefinitionClass() {
            return ServiceTask.class;
        }
    }
}

