/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConverterOptions;
import org.flowable.cmmn.converter.export.AbstractPlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.CriteriaExport;
import org.flowable.cmmn.converter.export.PlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.PlanItemExport;
import org.flowable.cmmn.converter.export.SentryExport;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.Stage;

public class StageExport
extends AbstractPlanItemDefinitionExport<Stage> {
    private static final StageExport instance = new StageExport();

    public static StageExport getInstance() {
        return instance;
    }

    protected StageExport() {
    }

    @Override
    protected Class<Stage> getExportablePlanItemDefinitionClass() {
        return Stage.class;
    }

    @Override
    protected String getPlanItemDefinitionXmlElementValue(Stage stage) {
        if (stage.isPlanModel()) {
            return "casePlanModel";
        }
        return "stage";
    }

    @Override
    protected void writePlanItemDefinitionSpecificAttributes(Stage stage, XMLStreamWriter xtw) throws Exception {
        super.writePlanItemDefinitionSpecificAttributes(stage, xtw);
        if (StringUtils.isNotEmpty((CharSequence)stage.getFormKey())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "formKey", stage.getFormKey());
        }
        if (!stage.isSameDeployment()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "sameDeployment", "false");
        }
        if (StringUtils.isNotEmpty((CharSequence)stage.getValidateFormFields())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "formFieldValidation", stage.getValidateFormFields());
        }
        if (stage.isAutoComplete()) {
            xtw.writeAttribute("autoComplete", Boolean.toString(stage.isAutoComplete()));
        }
        if (StringUtils.isNotEmpty((CharSequence)stage.getAutoCompleteCondition())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "autoCompleteCondition", stage.getAutoCompleteCondition());
        }
        if (stage.getDisplayOrder() != null) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "displayOrder", String.valueOf(stage.getDisplayOrder()));
        }
        if (StringUtils.isNotEmpty((CharSequence)stage.getIncludeInStageOverview()) && !"true".equalsIgnoreCase(stage.getIncludeInStageOverview())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "includeInStageOverview", stage.getIncludeInStageOverview());
        }
        if (StringUtils.isNotEmpty((CharSequence)stage.getBusinessStatus())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "businessStatus", stage.getBusinessStatus());
        }
    }

    @Override
    protected void writePlanItemDefinitionBody(CmmnModel model, Stage stage, XMLStreamWriter xtw, CmmnXmlConverterOptions options) throws Exception {
        super.writePlanItemDefinitionBody(model, stage, xtw, options);
        for (PlanItem planItem : stage.getPlanItems()) {
            PlanItemExport.writePlanItem(model, planItem, xtw);
        }
        for (Sentry sentry : stage.getSentries()) {
            SentryExport.writeSentry(model, sentry, xtw);
        }
        for (PlanItemDefinition planItemDefinition : stage.getPlanItemDefinitions()) {
            PlanItemDefinitionExport.writePlanItemDefinition(model, planItemDefinition, xtw, options);
        }
        if (stage.isPlanModel() && stage.getExitCriteria() != null && !stage.getExitCriteria().isEmpty()) {
            CriteriaExport.writeCriteriaElements("exitCriterion", stage.getExitCriteria(), xtw);
        }
    }
}

