/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.test.impl.CmmnJobTestHelper;
import org.flowable.cmmn.engine.test.impl.CmmnTestRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=CmmnTestRunner.class)
public abstract class FlowableCmmnTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableCmmnTestCase.class);
    public static String FLOWABLE_CMMN_CFG_XML = "flowable.cmmn.cfg.xml";
    protected static CmmnEngine cmmnEngine;
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected CmmnManagementService cmmnManagementService;
    protected CmmnRepositoryService cmmnRepositoryService;
    protected CmmnRuntimeService cmmnRuntimeService;
    protected CmmnTaskService cmmnTaskService;
    protected CmmnHistoryService cmmnHistoryService;
    protected String deploymentId;

    @BeforeClass
    public static void setupEngine() {
        if (CmmnTestRunner.getCmmnEngineConfiguration() == null) {
            FlowableCmmnTestCase.initCmmnEngine();
        }
    }

    protected static void initCmmnEngine() {
        try (InputStream inputStream = FlowableCmmnTestCase.class.getClassLoader().getResourceAsStream(FLOWABLE_CMMN_CFG_XML);){
            if (inputStream == null) {
                throw new RuntimeException("No " + FLOWABLE_CMMN_CFG_XML + " file found on the classpath");
            }
            cmmnEngine = CmmnEngineConfiguration.createCmmnEngineConfigurationFromInputStream(inputStream).buildCmmnEngine();
            CmmnTestRunner.setCmmnEngineConfiguration(cmmnEngine.getCmmnEngineConfiguration());
        }
        catch (IOException e) {
            LOGGER.error("Could not create CMMN engine", (Throwable)e);
        }
    }

    @Before
    public void setupServices() {
        CmmnEngineConfiguration cmmnEngineConfiguration;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration = CmmnTestRunner.getCmmnEngineConfiguration();
        this.cmmnRepositoryService = cmmnEngineConfiguration.getCmmnRepositoryService();
        this.cmmnManagementService = cmmnEngineConfiguration.getCmmnManagementService();
        this.cmmnRuntimeService = cmmnEngineConfiguration.getCmmnRuntimeService();
        this.cmmnTaskService = cmmnEngineConfiguration.getCmmnTaskService();
        this.cmmnHistoryService = cmmnEngineConfiguration.getCmmnHistoryService();
    }

    @After
    public void cleanup() {
        if (this.deploymentId != null) {
            this.cmmnRepositoryService.deleteDeployment(this.deploymentId, true);
        }
    }

    protected void deployOneHumanTaskCaseModel() {
        this.deploymentId = this.cmmnRepositoryService.createDeployment().addClasspathResource("org/flowable/cmmn/test/one-human-task-model.cmmn").deploy().getId();
    }

    protected void deployOneTaskCaseModel() {
        this.deploymentId = this.cmmnRepositoryService.createDeployment().addClasspathResource("org/flowable/cmmn/test/one-task-model.cmmn").deploy().getId();
    }

    protected Date setClockFixedToCurrentTime() {
        Date date = new Date();
        this.cmmnEngineConfiguration.getClock().setCurrentTime(date);
        return date;
    }

    protected void setClockTo(Date date) {
        this.cmmnEngineConfiguration.getClock().setCurrentTime(date);
    }

    protected Date forwardClock(long milliseconds) {
        long currentMillis = this.cmmnEngineConfiguration.getClock().getCurrentTime().getTime();
        Date date = new Date(currentMillis + milliseconds);
        this.cmmnEngineConfiguration.getClock().setCurrentTime(date);
        return date;
    }

    protected void assertCaseInstanceEnded(CaseInstance caseInstance) {
        Assert.assertEquals((String)"Plan item found for case instance", (long)0L, (long)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).count());
        Assert.assertEquals((String)"Runtime case instance found", (long)0L, (long)this.cmmnRuntimeService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).count());
        Assert.assertEquals((long)1L, (long)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstance.getId()).finished().count());
    }

    protected void assertCaseInstanceEnded(CaseInstance caseInstance, int nrOfExpectedMilestones) {
        this.assertCaseInstanceEnded(caseInstance);
        Assert.assertEquals((long)0L, (long)this.cmmnRuntimeService.createMilestoneInstanceQuery().milestoneInstanceCaseInstanceId(caseInstance.getId()).count());
        Assert.assertEquals((long)nrOfExpectedMilestones, (long)this.cmmnHistoryService.createHistoricMilestoneInstanceQuery().milestoneInstanceCaseInstanceId(caseInstance.getId()).count());
    }

    protected void assertCaseInstanceNotEnded(CaseInstance caseInstance) {
        Assert.assertTrue((String)"Found no plan items for case instance", (this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).count() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"No runtime case instance found", (this.cmmnRuntimeService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).count() > 0L ? 1 : 0) != 0);
        Assert.assertNull((String)"Historical case instance is already marked as ended", (Object)((HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult()).getEndTime());
    }

    protected void waitForJobExecutorToProcessAllJobs() {
        CmmnJobTestHelper.waitForJobExecutorToProcessAllJobs(this.cmmnEngineConfiguration, 10000L, 200L, true);
    }

    protected void waitForAsyncHistoryExecutorToProcessAllJobs() {
        CmmnJobTestHelper.waitForAsyncHistoryExecutorToProcessAllJobs(this.cmmnEngineConfiguration, 10000L, 200L, true);
    }
}

