/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.runtime.CaseInstanceState;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.converter.util.CriterionUtil;
import org.flowable.cmmn.converter.util.PlanItemUtil;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.criteria.PlanItemLifeCycleEvent;
import org.flowable.cmmn.engine.impl.listener.PlanItemLifeCycleListenerUtil;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CountingPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.EntityWithSentryPartInstances;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntityManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CaseInstanceUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceContainerUtil;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryIfPart;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.SignalEventListener;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateCriteriaOperation
extends AbstractCaseInstanceOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluateCriteriaOperation.class);
    protected PlanItemLifeCycleEvent planItemLifeCycleEvent;
    protected boolean evaluateCaseInstanceCompleted;

    public EvaluateCriteriaOperation(CommandContext commandContext, String caseInstanceEntityId) {
        super(commandContext, caseInstanceEntityId, null);
    }

    public EvaluateCriteriaOperation(CommandContext commandContext, String caseInstanceEntityId, PlanItemLifeCycleEvent planItemLifeCycleEvent) {
        super(commandContext, caseInstanceEntityId, null);
        this.planItemLifeCycleEvent = planItemLifeCycleEvent;
    }

    @Override
    public void run() {
        super.run();
        if (this.caseInstanceEntity.isDeleted()) {
            return;
        }
        String satisfiedExitCriterion = this.evaluateExitCriteria(this.caseInstanceEntity, (HasExitCriteria)this.getPlanModel(this.caseInstanceEntity));
        if (satisfiedExitCriterion != null) {
            CommandContextUtil.getAgenda(this.commandContext).planTerminateCaseInstanceOperation(this.caseInstanceEntity.getId(), satisfiedExitCriterion);
        } else {
            boolean criteriaChangeOrActiveChildren = this.evaluatePlanItemsCriteria(this.caseInstanceEntity);
            if (this.evaluateCaseInstanceCompleted && !criteriaChangeOrActiveChildren && !CaseInstanceState.END_STATES.contains(this.caseInstanceEntity.getState()) && this.evaluatePlanModelComplete()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No active plan items found for plan model, completing case instance");
                }
                CommandContextUtil.getAgenda(this.commandContext).planCompleteCaseInstanceOperation(this.caseInstanceEntity);
            }
        }
    }

    protected boolean evaluatePlanItemsCriteria(PlanItemInstanceContainer planItemInstanceContainer) {
        List<PlanItemInstanceEntity> planItemInstances = planItemInstanceContainer.getChildPlanItemInstances();
        int activeChildren = 0;
        boolean criteriaChanged = false;
        ArrayList<PlanItemInstanceEntity> newChildPlanItemInstances = null;
        for (int planItemInstanceIndex = 0; planItemInstanceIndex < planItemInstances.size(); ++planItemInstanceIndex) {
            PlanItemInstanceEntity planItemInstanceEntity = planItemInstances.get(planItemInstanceIndex);
            PlanItem planItem = planItemInstanceEntity.getPlanItem();
            String state = planItemInstanceEntity.getState();
            if (PlanItemInstanceState.EVALUATE_ENTRY_CRITERIA_STATES.contains(state)) {
                String satisfiedEntryCriterion = this.evaluateEntryCriteria(planItemInstanceEntity, planItem);
                if (planItem.getEntryCriteria().isEmpty() || satisfiedEntryCriterion != null) {
                    boolean activatePlanItemInstance = true;
                    if (!planItem.getEntryCriteria().isEmpty() && this.hasRepetitionRule(planItemInstanceEntity)) {
                        boolean isRepeating = this.evaluateRepetitionRule(planItemInstanceEntity);
                        if (isRepeating) {
                            PlanItemInstanceEntity childPlanItemInstanceEntity = this.createPlanItemInstanceDuplicateForRepetition(planItemInstanceEntity);
                            if (newChildPlanItemInstances == null) {
                                newChildPlanItemInstances = new ArrayList<PlanItemInstanceEntity>(1);
                            }
                            newChildPlanItemInstances.add(childPlanItemInstanceEntity);
                        } else {
                            activatePlanItemInstance = false;
                        }
                    }
                    if (planItem.getPlanItemDefinition() instanceof EventListener && !(planItem.getPlanItemDefinition() instanceof SignalEventListener)) {
                        activatePlanItemInstance = false;
                    }
                    if (activatePlanItemInstance) {
                        criteriaChanged = true;
                        CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(planItemInstanceEntity, satisfiedEntryCriterion);
                    }
                }
            }
            if (!PlanItemInstanceState.END_STATES.contains(state)) {
                String satisfiedExitCriterion = this.evaluateExitCriteria(planItemInstanceEntity, (HasExitCriteria)planItem);
                if (satisfiedExitCriterion != null) {
                    criteriaChanged = true;
                    CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(planItemInstanceEntity, satisfiedExitCriterion);
                } else if (planItem.getPlanItemDefinition() instanceof Stage) {
                    if ("active".equals(state)) {
                        boolean criteriaChangeOrActiveChildrenForStage = this.evaluatePlanItemsCriteria(planItemInstanceEntity);
                        if (criteriaChangeOrActiveChildrenForStage) {
                            criteriaChanged = true;
                            planItemInstanceEntity.setCompleteable(false);
                        } else {
                            Stage stage = (Stage)planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
                            if (this.isStageCompletable(planItemInstanceEntity, stage)) {
                                criteriaChanged = true;
                                CommandContextUtil.getAgenda(this.commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
                            }
                        }
                    }
                } else if ("active".equals(state)) {
                    ++activeChildren;
                }
            }
            if (planItemInstanceEntity.getState() != null) continue;
            criteriaChanged = true;
        }
        if (this.evaluatePlanItemsWithAvailableCondition(planItemInstanceContainer)) {
            criteriaChanged = true;
        }
        this.evaluateDependentPlanItems();
        if (newChildPlanItemInstances != null) {
            for (PlanItemInstanceEntity newChildPlanItemInstance : newChildPlanItemInstances) {
                planItemInstanceContainer.getChildPlanItemInstances().add(newChildPlanItemInstance);
            }
        }
        return criteriaChanged || activeChildren > 0;
    }

    protected String evaluateEntryCriteria(PlanItemInstanceEntity planItemInstanceEntity, PlanItem planItem) {
        List criteria = planItem.getEntryCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            return this.evaluateCriteria(planItemInstanceEntity, criteria);
        }
        return null;
    }

    protected String evaluateExitCriteria(EntityWithSentryPartInstances entityWithSentryPartInstances, HasExitCriteria hasExitCriteria) {
        List criteria = hasExitCriteria.getExitCriteria();
        if (criteria != null && !criteria.isEmpty()) {
            return this.evaluateCriteria(entityWithSentryPartInstances, criteria);
        }
        return null;
    }

    protected String evaluateCriteria(EntityWithSentryPartInstances entityWithSentryPartInstances, List<Criterion> criteria) {
        for (Criterion criterion : criteria) {
            boolean allOnPartsSatisfied;
            Sentry sentry = criterion.getSentry();
            if (sentry.getOnParts().size() == 1 && sentry.getSentryIfPart() == null) {
                SentryOnPart sentryOnPart;
                if (this.planItemLifeCycleEvent == null || !this.sentryOnPartMatchesCurrentLifeCycleEvent(sentryOnPart = (SentryOnPart)sentry.getOnParts().get(0))) continue;
                return criterion.getId();
            }
            if (sentry.getOnParts().isEmpty() && sentry.getSentryIfPart() != null) {
                if (!this.evaluateSentryIfPart(sentry, (VariableContainer)entityWithSentryPartInstances)) continue;
                return criterion.getId();
            }
            boolean isDefaultTriggerMode = sentry.isDefaultTriggerMode();
            boolean sentryIfPartSatisfied = false;
            HashSet<String> satisfiedSentryOnPartIds = new HashSet<String>(1);
            for (SentryPartInstanceEntity sentryPartInstanceEntity : entityWithSentryPartInstances.getSatisfiedSentryPartInstances()) {
                if (sentryPartInstanceEntity.getOnPartId() != null) {
                    satisfiedSentryOnPartIds.add(sentryPartInstanceEntity.getOnPartId());
                    continue;
                }
                if (sentryPartInstanceEntity.getIfPartId() == null || !sentryPartInstanceEntity.getIfPartId().equals(sentry.getSentryIfPart().getId())) continue;
                sentryIfPartSatisfied = true;
            }
            for (SentryOnPart sentryOnPart : sentry.getOnParts()) {
                if (satisfiedSentryOnPartIds.contains(sentryOnPart.getId()) || this.planItemLifeCycleEvent == null || !this.sentryOnPartMatchesCurrentLifeCycleEvent(sentryOnPart)) continue;
                this.createSentryPartInstanceEntity(entityWithSentryPartInstances, sentry, sentryOnPart, null);
                satisfiedSentryOnPartIds.add(sentryOnPart.getId());
            }
            boolean bl = allOnPartsSatisfied = satisfiedSentryOnPartIds.size() == sentry.getOnParts().size();
            if (sentry.getSentryIfPart() != null && !sentryIfPartSatisfied && (isDefaultTriggerMode || sentry.isOnEventTriggerMode() && allOnPartsSatisfied) && this.evaluateSentryIfPart(sentry, (VariableContainer)entityWithSentryPartInstances)) {
                this.createSentryPartInstanceEntity(entityWithSentryPartInstances, sentry, null, sentry.getSentryIfPart());
                sentryIfPartSatisfied = true;
            }
            if (!allOnPartsSatisfied || !sentryIfPartSatisfied && sentry.getSentryIfPart() != null) continue;
            return criterion.getId();
        }
        return null;
    }

    public boolean sentryOnPartMatchesCurrentLifeCycleEvent(SentryOnPart sentryOnPart) {
        return this.planItemLifeCycleEvent.getPlanItem().getId().equals(sentryOnPart.getSourceRef()) && this.planItemLifeCycleEvent.getTransition().equals(sentryOnPart.getStandardEvent());
    }

    protected SentryPartInstanceEntity createSentryPartInstanceEntity(EntityWithSentryPartInstances entityWithSentryPartInstances, Sentry sentry, SentryOnPart sentryOnPart, SentryIfPart sentryIfPart) {
        SentryPartInstanceEntityManager sentryPartInstanceEntityManager = CommandContextUtil.getSentryPartInstanceEntityManager(this.commandContext);
        SentryPartInstanceEntity sentryPartInstanceEntity = (SentryPartInstanceEntity)sentryPartInstanceEntityManager.create();
        sentryPartInstanceEntity.setTimeStamp(CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getClock().getCurrentTime());
        if (sentryOnPart != null) {
            sentryPartInstanceEntity.setOnPartId(sentryOnPart.getId());
        } else if (sentryIfPart != null) {
            sentryPartInstanceEntity.setIfPartId(sentryIfPart.getId());
        }
        if (entityWithSentryPartInstances instanceof CaseInstanceEntity) {
            sentryPartInstanceEntity.setCaseInstanceId(((CaseInstanceEntity)entityWithSentryPartInstances).getId());
            sentryPartInstanceEntity.setCaseDefinitionId(((CaseInstanceEntity)entityWithSentryPartInstances).getCaseDefinitionId());
        } else if (entityWithSentryPartInstances instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)entityWithSentryPartInstances;
            sentryPartInstanceEntity.setCaseInstanceId(planItemInstanceEntity.getCaseInstanceId());
            sentryPartInstanceEntity.setCaseDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
            sentryPartInstanceEntity.setPlanItemInstanceId(planItemInstanceEntity.getId());
            if (sentry.isDefaultTriggerMode() && entityWithSentryPartInstances instanceof CountingPlanItemInstanceEntity) {
                CountingPlanItemInstanceEntity countingPlanItemInstanceEntity = (CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity);
                countingPlanItemInstanceEntity.setSentryPartInstanceCount(countingPlanItemInstanceEntity.getSentryPartInstanceCount() + 1);
            }
        }
        if (sentry.isDefaultTriggerMode()) {
            sentryPartInstanceEntityManager.insert(sentryPartInstanceEntity);
        }
        entityWithSentryPartInstances.getSatisfiedSentryPartInstances().add(sentryPartInstanceEntity);
        return sentryPartInstanceEntity;
    }

    protected boolean evaluateSentryIfPart(Sentry sentry, VariableContainer variableContainer) {
        Expression conditionExpression = CommandContextUtil.getExpressionManager(this.commandContext).createExpression(sentry.getSentryIfPart().getCondition());
        Object result = conditionExpression.getValue(variableContainer);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    protected boolean isAvailableChildPlanCompletionNeutralOrNotActive(PlanItemInstanceContainer planItemInstanceContainer) {
        if (planItemInstanceContainer.getChildPlanItemInstances() != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : planItemInstanceContainer.getChildPlanItemInstances()) {
                if (PlanItemInstanceState.END_STATES.contains(childPlanItemInstance.getState()) || "available".contains(childPlanItemInstance.getState()) && ExpressionUtil.isCompletionNeutralPlanItemInstance(childPlanItemInstance)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isStageCompletable(PlanItemInstanceEntity stagePlanItemInstanceEntity, Stage stage) {
        boolean allRequiredChildrenInEndState = PlanItemInstanceContainerUtil.isEndStateReachedForAllRequiredChildPlanItems(this.commandContext, stagePlanItemInstanceEntity);
        if (allRequiredChildrenInEndState) {
            stagePlanItemInstanceEntity.setCompleteable(true);
        }
        if (stagePlanItemInstanceEntity.isCompleteable()) {
            if (stage.isAutoComplete()) {
                return true;
            }
            return this.isAvailableChildPlanCompletionNeutralOrNotActive(stagePlanItemInstanceEntity);
        }
        return false;
    }

    protected boolean evaluatePlanModelComplete() {
        boolean allRequiredChildrenInEndState = PlanItemInstanceContainerUtil.isEndStateReachedForAllRequiredChildPlanItems(this.commandContext, this.caseInstanceEntity);
        if (allRequiredChildrenInEndState) {
            boolean planItemInstancesChanged;
            boolean previousCompleteableState = this.caseInstanceEntity.isCompleteable();
            this.caseInstanceEntity.setCompleteable(true);
            if (previousCompleteableState != this.caseInstanceEntity.isCompleteable() && (planItemInstancesChanged = this.evaluatePlanItemsWithAvailableCondition(this.caseInstanceEntity)) && !(allRequiredChildrenInEndState = PlanItemInstanceContainerUtil.isEndStateReachedForAllRequiredChildPlanItems(this.commandContext, this.caseInstanceEntity))) {
                this.caseInstanceEntity.setCompleteable(false);
            }
        }
        if (this.caseInstanceEntity.isCompleteable()) {
            if (CaseDefinitionUtil.getCase(this.caseInstanceEntity.getCaseDefinitionId()).getPlanModel().isAutoComplete()) {
                return true;
            }
            return this.isAvailableChildPlanCompletionNeutralOrNotActive(this.caseInstanceEntity);
        }
        return false;
    }

    protected boolean evaluatePlanItemsWithAvailableCondition(PlanItemInstanceContainer planItemInstanceContainer) {
        if (!planItemInstanceContainer.getPlanItems().isEmpty()) {
            List<PlanItemInstanceEntity> planItemInstanceToInitiate = this.findChangedEventListenerInstances(planItemInstanceContainer, "unavailable", true);
            if (!planItemInstanceToInitiate.isEmpty()) {
                for (PlanItemInstanceEntity planItemInstanceEntity : planItemInstanceToInitiate) {
                    CommandContextUtil.getAgenda(this.commandContext).planInitiatePlanItemInstanceOperation(planItemInstanceEntity);
                }
                return true;
            }
            List<PlanItemInstanceEntity> planItemInstanceToDismiss = this.findChangedEventListenerInstances(planItemInstanceContainer, "available", false);
            if (!planItemInstanceToDismiss.isEmpty()) {
                for (PlanItemInstanceEntity planItemInstanceEntity : planItemInstanceToDismiss) {
                    CommandContextUtil.getAgenda(this.commandContext).planDismissPlanItemInstanceOperation(planItemInstanceEntity);
                }
                return true;
            }
        }
        return false;
    }

    protected List<PlanItemInstanceEntity> findChangedEventListenerInstances(PlanItemInstanceContainer planItemInstanceContainer, String state, boolean conditionValueToChange) {
        return planItemInstanceContainer.getChildPlanItemInstances().stream().filter(planItemInstance -> state.equals(planItemInstance.getState()) && this.isEventListenerWithAvailableCondition(planItemInstance.getPlanItem()) && conditionValueToChange == this.evaluateAvailableCondition(this.commandContext, (PlanItemInstanceEntity)planItemInstance)).collect(Collectors.toList());
    }

    protected boolean evaluateAvailableCondition(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        EventListener eventListener;
        PlanItem planItem = planItemInstanceEntity.getPlanItem();
        if (this.isEventListenerWithAvailableCondition(planItem) && StringUtils.isNotEmpty((CharSequence)(eventListener = (EventListener)planItem.getPlanItemDefinition()).getAvailableConditionExpression())) {
            Expression expression = CommandContextUtil.getExpressionManager(commandContext).createExpression(eventListener.getAvailableConditionExpression());
            Object result = expression.getValue((VariableContainer)planItemInstanceEntity);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return false;
        }
        return true;
    }

    protected void evaluateDependentPlanItems() {
        if (this.planItemLifeCycleEvent == null) {
            return;
        }
        List entryDependentPlanItems = this.planItemLifeCycleEvent.getPlanItem().getEntryDependentPlanItems();
        for (PlanItem entryDependentPlanItem : entryDependentPlanItems) {
            String satisfiedCriterion;
            if (this.planItemsShareDirectParentStage(entryDependentPlanItem, this.planItemLifeCycleEvent.getPlanItem()) || !CriterionUtil.planItemHasOneEntryCriterionDependingOnPlanItem((PlanItem)entryDependentPlanItem, (PlanItem)this.planItemLifeCycleEvent.getPlanItem(), (String)this.planItemLifeCycleEvent.getTransition())) continue;
            PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(this.commandContext);
            List<PlanItemInstanceEntity> childPlanItemInstances = CaseInstanceUtil.findChildPlanItemInstances(this.caseInstanceEntity, entryDependentPlanItem);
            List<PlanItemInstanceEntity> potentialTerminatedPlanItemInstances = planItemInstanceEntityManager.findByCaseInstanceIdAndPlanItemId(this.caseInstanceEntity.getId(), entryDependentPlanItem.getId());
            if (!childPlanItemInstances.isEmpty() || !potentialTerminatedPlanItemInstances.isEmpty() && (!this.hasRepetitionRule(entryDependentPlanItem) || !this.evaluateRepetitionRule((VariableContainer)this.caseInstanceEntity, entryDependentPlanItem.getItemControl().getRepetitionRule().getCondition())) || (satisfiedCriterion = this.evaluateDependentPlanItemEntryCriteria(entryDependentPlanItem)) == null) continue;
            List parentPlanItems = PlanItemUtil.getAllParentPlanItems((PlanItem)entryDependentPlanItem);
            Map<String, List<PlanItemInstanceEntity>> existingPlanItemInstancesMap = CaseInstanceUtil.findChildPlanItemInstancesMap(this.caseInstanceEntity, parentPlanItems);
            ArrayList<PlanItemInstanceEntity> parentPlanItemInstancesToActivate = new ArrayList<PlanItemInstanceEntity>();
            Object previousParentPlanItemInstance = null;
            for (int i = parentPlanItems.size() - 1; i >= 0; --i) {
                PlanItem parentPlanItem = (PlanItem)parentPlanItems.get(i);
                List<PlanItemInstanceEntity> parentPlanItemInstances = existingPlanItemInstancesMap.get(parentPlanItem.getId());
                if (parentPlanItemInstances == null || parentPlanItemInstances.isEmpty()) {
                    PlanItemInstanceEntity parentPlanItemInstance = planItemInstanceEntityManager.createChildPlanItemInstance(parentPlanItem, this.caseInstanceEntity.getCaseDefinitionId(), this.caseInstanceEntity.getId(), previousParentPlanItemInstance != null ? previousParentPlanItemInstance.getId() : null, this.caseInstanceEntity.getTenantId(), true);
                    parentPlanItemInstancesToActivate.add(parentPlanItemInstance);
                    previousParentPlanItemInstance = parentPlanItemInstance;
                    continue;
                }
                for (PlanItemInstanceEntity parentPlanItemInstance : parentPlanItemInstances) {
                    if ("active".equals(parentPlanItemInstance.getState())) continue;
                    parentPlanItemInstancesToActivate.add(parentPlanItemInstance);
                }
                previousParentPlanItemInstance = (PlanItemInstance)parentPlanItemInstances.get(0);
            }
            PlanItemInstanceEntity entryDependentPlanItemInstance = planItemInstanceEntityManager.createChildPlanItemInstance(entryDependentPlanItem, this.caseInstanceEntity.getCaseDefinitionId(), this.caseInstanceEntity.getId(), previousParentPlanItemInstance != null ? previousParentPlanItemInstance.getId() : null, this.caseInstanceEntity.getTenantId(), true);
            CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceOperation(entryDependentPlanItemInstance);
            if (!entryDependentPlanItem.getEntryCriteria().isEmpty() && this.hasRepetitionRule(entryDependentPlanItemInstance) && this.evaluateRepetitionRule(entryDependentPlanItemInstance)) {
                this.createPlanItemInstanceDuplicateForRepetition(entryDependentPlanItemInstance);
            }
            CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(entryDependentPlanItemInstance, satisfiedCriterion);
            for (int i = parentPlanItemInstancesToActivate.size() - 1; i >= 0; --i) {
                PlanItemInstanceEntity parentPlanItemInstance = (PlanItemInstanceEntity)parentPlanItemInstancesToActivate.get(i);
                if (parentPlanItemInstance == null) {
                    CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceOperation(parentPlanItemInstance);
                }
                CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(parentPlanItemInstance, null);
            }
        }
    }

    protected String evaluateDependentPlanItemEntryCriteria(PlanItem entryDependentPlanItem) {
        List entryCriteria = entryDependentPlanItem.getEntryCriteria();
        if (!entryCriteria.isEmpty()) {
            for (Criterion criterion : entryCriteria) {
                if (!CriterionUtil.criterionHasOnPartDependingOnPlanItem((Criterion)criterion, (PlanItem)this.planItemLifeCycleEvent.getPlanItem(), (String)this.planItemLifeCycleEvent.getTransition())) continue;
                boolean criterionSatisfied = true;
                List onParts = criterion.getSentry().getOnParts();
                for (SentryOnPart onPart : onParts) {
                    if (this.sentryOnPartMatchesCurrentLifeCycleEvent(onPart)) continue;
                    criterionSatisfied = false;
                }
                if (criterion.getSentry().getSentryIfPart() != null && !this.evaluateSentryIfPart(criterion.getSentry(), (VariableContainer)this.caseInstanceEntity)) {
                    criterionSatisfied = false;
                }
                if (!criterionSatisfied) continue;
                return criterion.getId();
            }
        }
        return null;
    }

    protected PlanItemInstanceEntity createPlanItemInstanceDuplicateForRepetition(PlanItemInstanceEntity planItemInstanceEntity) {
        PlanItemInstanceEntity childPlanItemInstanceEntity = this.copyAndInsertPlanItemInstance(this.commandContext, planItemInstanceEntity, false);
        String oldState = childPlanItemInstanceEntity.getState();
        String newState = "wait_repetition";
        childPlanItemInstanceEntity.setState(newState);
        PlanItemLifeCycleListenerUtil.callLifecycleListeners(this.commandContext, planItemInstanceEntity, oldState, newState);
        CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceForRepetitionOperation(childPlanItemInstanceEntity);
        return childPlanItemInstanceEntity;
    }

    protected boolean planItemsShareDirectParentStage(PlanItem planItemOne, PlanItem planItemTwo) {
        Stage parentStage = planItemOne.getParentStage();
        return parentStage.findPlanItemInPlanFragmentOrDownwards(planItemTwo.getId()) != null;
    }

    public PlanItemLifeCycleEvent getPlanItemLifeCycleEvent() {
        return this.planItemLifeCycleEvent;
    }

    public void setPlanItemLifeCycleEvent(PlanItemLifeCycleEvent planItemLifeCycleEvent) {
        this.planItemLifeCycleEvent = planItemLifeCycleEvent;
    }

    public boolean isEvaluateCaseInstanceCompleted() {
        return this.evaluateCaseInstanceCompleted;
    }

    public void setEvaluateCaseInstanceCompleted(boolean evaluateCaseInstanceCompleted) {
        this.evaluateCaseInstanceCompleted = evaluateCaseInstanceCompleted;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Evaluate Criteria] case instance ");
        if (this.caseInstanceEntity != null) {
            stringBuilder.append(this.caseInstanceEntity.getId());
        } else {
            stringBuilder.append(this.caseInstanceEntityId);
        }
        if (this.planItemLifeCycleEvent != null) {
            stringBuilder.append(" with transition '").append(this.planItemLifeCycleEvent.getTransition()).append("' having fired");
            if (this.planItemLifeCycleEvent.getPlanItem() != null) {
                stringBuilder.append(" for plan item ").append(this.planItemLifeCycleEvent.getPlanItem().getId());
                if (this.planItemLifeCycleEvent.getPlanItem().getName() != null) {
                    stringBuilder.append(" (").append(this.planItemLifeCycleEvent.getPlanItem().getName()).append(")");
                }
            }
        }
        return stringBuilder.toString();
    }
}

