/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.Collection;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class PlanItemInstanceContainerUtil {
    public static boolean isEndStateReachedForAllChildPlanItems(PlanItemInstanceContainer planItemInstanceContainer) {
        return PlanItemInstanceContainerUtil.isEndStateReachedForAllChildPlanItems(planItemInstanceContainer, null);
    }

    public static boolean isEndStateReachedForAllChildPlanItems(PlanItemInstanceContainer planItemInstanceContainer, Collection<String> planItemInstanceIdsToIgnore) {
        if (planItemInstanceContainer.getChildPlanItemInstances() != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : planItemInstanceContainer.getChildPlanItemInstances()) {
                if (planItemInstanceIdsToIgnore != null && planItemInstanceIdsToIgnore.contains(childPlanItemInstance.getId())) continue;
                if (!PlanItemInstanceState.END_STATES.contains(childPlanItemInstance.getState())) {
                    return false;
                }
                boolean allChildChildsEndStateReached = PlanItemInstanceContainerUtil.isEndStateReachedForAllChildPlanItems(childPlanItemInstance);
                if (allChildChildsEndStateReached) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEndStateReachedForAllRequiredChildPlanItems(PlanItemInstanceContainer planItemInstanceContainer) {
        return PlanItemInstanceContainerUtil.isEndStateReachedForAllRequiredChildPlanItems(CommandContextUtil.getCommandContext(), planItemInstanceContainer);
    }

    public static boolean isEndStateReachedForAllRequiredChildPlanItems(CommandContext commandContext, PlanItemInstanceContainer planItemInstanceContainer) {
        return PlanItemInstanceContainerUtil.isEndStateReachedForAllRequiredChildPlanItems(commandContext, planItemInstanceContainer, null);
    }

    public static boolean isEndStateReachedForAllRequiredChildPlanItems(PlanItemInstanceContainer planItemInstanceContainer, Collection<String> planItemInstanceIdsToIgnore) {
        return PlanItemInstanceContainerUtil.isEndStateReachedForAllRequiredChildPlanItems(CommandContextUtil.getCommandContext(), planItemInstanceContainer, planItemInstanceIdsToIgnore);
    }

    public static boolean isEndStateReachedForAllRequiredChildPlanItems(CommandContext commandContext, PlanItemInstanceContainer planItemInstanceContainer, Collection<String> planItemInstanceIdsToIgnore) {
        if (planItemInstanceContainer.getChildPlanItemInstances() != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : planItemInstanceContainer.getChildPlanItemInstances()) {
                if (planItemInstanceIdsToIgnore != null && planItemInstanceIdsToIgnore.contains(childPlanItemInstance.getId()) || PlanItemInstanceState.END_STATES.contains(childPlanItemInstance.getState())) continue;
                if (ExpressionUtil.isRequiredPlanItemInstance(commandContext, childPlanItemInstance)) {
                    return false;
                }
                if ("active".equals(childPlanItemInstance.getState())) {
                    return false;
                }
                if (PlanItemInstanceContainerUtil.isEndStateReachedForAllChildPlanItems(childPlanItemInstance)) continue;
                return false;
            }
        }
        return true;
    }
}

