/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.async.json.transformer.AbstractTaskHistoryJsonTransformer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;

public class TaskEndedHistoryJsonTransformer
extends AbstractTaskHistoryJsonTransformer {
    public TaskEndedHistoryJsonTransformer(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("cmmn-task-removed");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return this.getHistoricTaskEntity(historicalData, commandContext) != null;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricTaskInstanceEntity historicTaskInstance = this.getHistoricTaskEntity(historicalData, commandContext);
        if (historicTaskInstance != null) {
            Date lastUpdateTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"endTime");
            if (historicTaskInstance.getLastUpdateTime() == null || !historicTaskInstance.getLastUpdateTime().after(lastUpdateTime)) {
                historicTaskInstance.setLastUpdateTime(lastUpdateTime);
                this.copyCommonHistoricTaskInstanceFields(historicalData, historicTaskInstance);
            }
            this.setEndProperties(historicalData, historicTaskInstance);
        } else {
            HistoricTaskService historicTaskService = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
            HistoricTaskInstanceEntity historicTaskInstanceEntity = historicTaskService.createHistoricTask();
            this.copyCommonHistoricTaskInstanceFields(historicalData, historicTaskInstanceEntity);
            this.setEndProperties(historicalData, historicTaskInstanceEntity);
            historicTaskService.insertHistoricTask(historicTaskInstanceEntity, false);
        }
    }

    protected void setEndProperties(ObjectNode historicalData, HistoricTaskInstanceEntity historicTaskInstance) {
        Date endTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"endTime");
        historicTaskInstance.setEndTime(endTime);
        historicTaskInstance.setDeleteReason(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"deleteReason"));
        Date startTime = historicTaskInstance.getStartTime();
        if (startTime != null && endTime != null) {
            historicTaskInstance.setDurationInMillis(Long.valueOf(endTime.getTime() - startTime.getTime()));
        }
    }
}

