/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity.data.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.data.AbstractCmmnDataManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseInstanceDataManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.impl.matcher.CaseInstanceByCaseDefinitionIdMatcher;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryImpl;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class MybatisCaseInstanceDataManagerImpl
extends AbstractCmmnDataManager<CaseInstanceEntity>
implements CaseInstanceDataManager {
    protected CaseInstanceByCaseDefinitionIdMatcher caseInstanceByCaseDefinitionIdMatcher = new CaseInstanceByCaseDefinitionIdMatcher();

    public MybatisCaseInstanceDataManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public Class<? extends CaseInstanceEntity> getManagedEntityClass() {
        return CaseInstanceEntityImpl.class;
    }

    public CaseInstanceEntity create() {
        CaseInstanceEntityImpl caseInstanceEntityImpl = new CaseInstanceEntityImpl();
        caseInstanceEntityImpl.setChildPlanItemInstances(new ArrayList<PlanItemInstanceEntity>(1));
        caseInstanceEntityImpl.setSatisfiedSentryPartInstances(new ArrayList<SentryPartInstanceEntity>(1));
        caseInstanceEntityImpl.internalSetVariableInstances(new HashMap(1));
        return caseInstanceEntityImpl;
    }

    @Override
    public CaseInstanceEntity create(HistoricCaseInstance historicCaseInstance, Map<String, VariableInstanceEntity> variables) {
        return new CaseInstanceEntityImpl(historicCaseInstance, variables);
    }

    public CaseInstanceEntity findById(String caseInstanceId) {
        return this.findCaseInstanceEntityEagerFetchPlanItemInstances(caseInstanceId, null);
    }

    @Override
    public CaseInstanceEntity findCaseInstanceEntityEagerFetchPlanItemInstances(String caseInstanceId, String planItemInstanceId) {
        EntityCache entityCache = this.getEntityCache();
        CaseInstanceEntity cachedCaseInstanceEntity = (CaseInstanceEntity)entityCache.findInCache(this.getManagedEntityClass(), caseInstanceId);
        if (cachedCaseInstanceEntity != null) {
            return cachedCaseInstanceEntity;
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        if (caseInstanceId != null) {
            params.put("caseInstanceId", caseInstanceId);
        } else if (planItemInstanceId != null) {
            params.put("planItemInstanceId", planItemInstanceId);
        }
        if (params.isEmpty()) {
            throw new FlowableIllegalArgumentException("selectCaseInstanceEagerFetchPlanItemInstances needs either caseInstanceId or planItemInstanceId");
        }
        CaseInstanceEntityImpl caseInstanceEntity = (CaseInstanceEntityImpl)this.getDbSqlSession().selectOne("selectCaseInstanceEagerFetchPlanItemInstances", params);
        if (caseInstanceEntity != null) {
            List<PlanItemInstanceEntity> allPlanItemInstances = caseInstanceEntity.getChildPlanItemInstances();
            ArrayList<PlanItemInstanceEntity> directPlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
            HashMap<String, PlanItemInstanceEntity> planItemInstanceMap = new HashMap<String, PlanItemInstanceEntity>(allPlanItemInstances.size());
            Iterator<PlanItemInstanceEntity> iterator = allPlanItemInstances.iterator();
            while (iterator.hasNext()) {
                PlanItemInstanceEntity planItemInstanceEntity;
                PlanItemInstanceEntity currentPlanItemInstanceEntity = planItemInstanceEntity = iterator.next();
                PlanItemInstanceEntity planItemInstanceFromCache = (PlanItemInstanceEntity)entityCache.findInCache(PlanItemInstanceEntityImpl.class, planItemInstanceEntity.getId());
                if (planItemInstanceFromCache != null) {
                    planItemInstanceMap.put(planItemInstanceFromCache.getId(), planItemInstanceFromCache);
                    currentPlanItemInstanceEntity = planItemInstanceFromCache;
                } else {
                    planItemInstanceMap.put(planItemInstanceEntity.getId(), planItemInstanceEntity);
                    entityCache.put((Entity)planItemInstanceEntity, true);
                    currentPlanItemInstanceEntity.setChildPlanItemInstances(new ArrayList());
                }
                if (currentPlanItemInstanceEntity.getStageInstanceId() != null) continue;
                directPlanItemInstances.add(currentPlanItemInstanceEntity);
            }
            if (directPlanItemInstances.size() != planItemInstanceMap.size()) {
                for (PlanItemInstanceEntity planItemInstanceEntity : allPlanItemInstances) {
                    PlanItemInstanceEntity parentPlanItemInstanceEntity;
                    if (planItemInstanceEntity.getStageInstanceId() == null || (parentPlanItemInstanceEntity = (PlanItemInstanceEntity)planItemInstanceMap.get(planItemInstanceEntity.getStageInstanceId())) == null) continue;
                    parentPlanItemInstanceEntity.getChildPlanItemInstances().add(planItemInstanceMap.get(planItemInstanceEntity.getId()));
                }
            }
            caseInstanceEntity.setChildPlanItemInstances(directPlanItemInstances);
            return caseInstanceEntity;
        }
        return null;
    }

    @Override
    public List<CaseInstanceEntity> findCaseInstancesByCaseDefinitionId(String caseDefinitionId) {
        return this.getList("selectCaseInstancesByCaseDefinitionId", caseDefinitionId, (CachedEntityMatcher)this.caseInstanceByCaseDefinitionIdMatcher, true);
    }

    @Override
    public List<CaseInstance> findByCriteria(CaseInstanceQueryImpl query) {
        this.setSafeInValueLists(query);
        return this.getDbSqlSession().selectListNoCacheLoadAndStore("selectCaseInstancesByQueryCriteria", (ListQueryParameterObject)query, this.getManagedEntityClass());
    }

    @Override
    public List<CaseInstance> findWithVariablesByCriteria(CaseInstanceQueryImpl query) {
        this.setSafeInValueLists(query);
        return this.getDbSqlSession().selectListNoCacheLoadAndStore("selectCaseInstanceWithVariablesByQueryCriteria", (ListQueryParameterObject)query, this.getManagedEntityClass());
    }

    @Override
    public long countByCriteria(CaseInstanceQueryImpl query) {
        this.setSafeInValueLists(query);
        return (Long)this.getDbSqlSession().selectOne("selectCaseInstanceCountByQueryCriteria", (Object)query);
    }

    @Override
    public void updateLockTime(String caseInstanceId, Date lockDate, String lockOwner, Date expirationTime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", caseInstanceId);
        params.put("lockTime", lockDate);
        params.put("expirationTime", expirationTime);
        params.put("lockOwner", lockOwner);
        int result = this.getDbSqlSession().directUpdate("updateCaseInstanceLockTime", params);
        if (result == 0) {
            throw new FlowableOptimisticLockingException("Could not lock case instance");
        }
    }

    @Override
    public void clearLockTime(String caseInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", caseInstanceId);
        this.getDbSqlSession().directUpdate("clearCaseInstanceLockTime", params);
    }

    @Override
    public void clearAllLockTimes(String lockOwner) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lockOwner", lockOwner);
        this.getDbSqlSession().directUpdate("clearAllCaseInstanceLockTimes", params);
    }

    protected void setSafeInValueLists(CaseInstanceQueryImpl caseInstanceQuery) {
        if (caseInstanceQuery.getInvolvedGroups() != null) {
            caseInstanceQuery.setSafeInvolvedGroups(this.createSafeInValuesList(caseInstanceQuery.getInvolvedGroups()));
        }
        if (caseInstanceQuery.getOrQueryObjects() != null && !caseInstanceQuery.getOrQueryObjects().isEmpty()) {
            for (CaseInstanceQueryImpl orCaseInstanceQuery : caseInstanceQuery.getOrQueryObjects()) {
                this.setSafeInValueLists(orCaseInstanceQuery);
            }
        }
    }
}

