/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.engine.impl.parser.CmmnParseHandler;
import org.flowable.cmmn.engine.impl.parser.CmmnParseResult;
import org.flowable.cmmn.engine.impl.parser.CmmnParser;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.PlanItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnParseHandlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnParseHandlers.class);
    protected Map<Class<? extends BaseElement>, List<CmmnParseHandler>> parseHandlers = new HashMap<Class<? extends BaseElement>, List<CmmnParseHandler>>();

    public CmmnParseHandlers() {
    }

    public CmmnParseHandlers(List<CmmnParseHandler> cmmnParseHandlers) {
        cmmnParseHandlers.forEach(this::addHandler);
    }

    public void addHandlers(List<CmmnParseHandler> cmmnParseHandlers) {
        cmmnParseHandlers.forEach(this::addHandler);
    }

    public void addHandler(CmmnParseHandler cmmnParseHandler) {
        for (Class<? extends BaseElement> type : cmmnParseHandler.getHandledTypes()) {
            this.parseHandlers.computeIfAbsent(type, key -> new ArrayList()).add(cmmnParseHandler);
        }
    }

    public void parseElement(CmmnParser cmmnParser, CmmnParseResult cmmnParseResult, BaseElement baseElement) {
        List<CmmnParseHandler> handlers = null;
        if (baseElement instanceof PlanItem) {
            PlanItem planItem = (PlanItem)baseElement;
            handlers = this.parseHandlers.get(planItem.getPlanItemDefinition().getClass());
            if (handlers == null) {
                LOGGER.warn("Could not find matching parse handler for planItem '{}' with planItemDefinition '{}'. This is likely a bug.", (Object)baseElement.getId(), (Object)planItem.getPlanItemDefinition());
            } else {
                handlers.forEach(handler -> handler.parse(cmmnParser, cmmnParseResult, (BaseElement)planItem));
            }
        } else {
            handlers = this.parseHandlers.get(baseElement.getClass());
            if (handlers == null) {
                LOGGER.warn("Could not find matching parse handler for '{}' this is likely a bug.", (Object)baseElement.getId());
            } else {
                handlers.forEach(handler -> handler.parse(cmmnParser, cmmnParseResult, baseElement));
            }
        }
    }
}

