/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;

public class DeleteHistoricTaskInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public DeleteHistoricTaskInstanceCmd(String taskId) {
        this.taskId = taskId;
    }

    public Object execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        HistoricTaskInstanceEntity historicTaskInstance = CommandContextUtil.getHistoricTaskService().getHistoricTask(this.taskId);
        if (historicTaskInstance == null) {
            throw new FlowableObjectNotFoundException("No historic task instance found with id: " + this.taskId, HistoricTaskInstance.class);
        }
        if (historicTaskInstance.getEndTime() == null) {
            throw new FlowableException("task does not have an endTime, cannot delete " + historicTaskInstance);
        }
        CommandContextUtil.getCmmnHistoryManager(commandContext).recordHistoricTaskDeleted((HistoricTaskInstance)historicTaskInstance);
        return null;
    }
}

