/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.flowable.cmmn.api.migration.ActivatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.CaseInstanceMigrationDocument;
import org.flowable.cmmn.api.migration.ChangePlanItemDefinitionWithNewTargetIdsMapping;
import org.flowable.cmmn.api.migration.ChangePlanItemIdMapping;
import org.flowable.cmmn.api.migration.ChangePlanItemIdWithDefinitionIdMapping;
import org.flowable.cmmn.api.migration.MoveToAvailablePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.RemoveWaitingForRepetitionPlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.TerminatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.WaitingForRepetitionPlanItemDefinitionMapping;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationDocumentBuilderImpl;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationDocumentConstants;
import org.flowable.common.engine.api.FlowableException;

public class CaseInstanceMigrationDocumentConverter
implements CaseInstanceMigrationDocumentConstants {
    protected static Predicate<JsonNode> isNotNullNode = jsonNode -> jsonNode != null && !jsonNode.isNull();
    protected static Predicate<JsonNode> isSingleTextValue = jsonNode -> isNotNullNode.test((JsonNode)jsonNode) && jsonNode.isTextual();
    protected static Predicate<JsonNode> isMultiValue = jsonNode -> isNotNullNode.test((JsonNode)jsonNode) && jsonNode.isArray();
    protected static ObjectMapper objectMapper = new ObjectMapper();

    public static JsonNode convertToJson(CaseInstanceMigrationDocument caseInstanceMigrationDocument) {
        JsonNode caseInstanceVariablesNode;
        ArrayNode changePlanItemDefinitionWithNewTargetIdsMappingNodes;
        ArrayNode changePlanItemIdWithDefinitionIdMappingNodes;
        ArrayNode changePlanItemIdMappingNodes;
        ArrayNode removeWaitingForRepetitionMappingNodes;
        ArrayNode waitingForRepetitionMappingNodes;
        ArrayNode moveToAvailableMappingNodes;
        ArrayNode terminateMappingNodes;
        ArrayNode activateMappingNodes;
        ObjectNode documentNode = objectMapper.createObjectNode();
        if (caseInstanceMigrationDocument.getMigrateToCaseDefinitionId() != null) {
            documentNode.put("toCaseDefinitionId", caseInstanceMigrationDocument.getMigrateToCaseDefinitionId());
        }
        if (caseInstanceMigrationDocument.getMigrateToCaseDefinitionKey() != null) {
            documentNode.put("toCaseDefinitionKey", caseInstanceMigrationDocument.getMigrateToCaseDefinitionKey());
        }
        if (caseInstanceMigrationDocument.getMigrateToCaseDefinitionVersion() != null) {
            documentNode.put("toCaseDefinitionVersion", caseInstanceMigrationDocument.getMigrateToCaseDefinitionVersion());
        }
        if (caseInstanceMigrationDocument.getMigrateToCaseDefinitionTenantId() != null) {
            documentNode.put("toCaseDefinitionTenantId", caseInstanceMigrationDocument.getMigrateToCaseDefinitionTenantId());
        }
        if ((activateMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonActivatePlanItemDefinitionMappings(caseInstanceMigrationDocument.getActivatePlanItemDefinitionMappings())) != null && !activateMappingNodes.isNull()) {
            documentNode.set("activatePlanItemDefinitions", (JsonNode)activateMappingNodes);
        }
        if ((terminateMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonTerminatePlanItemDefinitionMappings(caseInstanceMigrationDocument.getTerminatePlanItemDefinitionMappings())) != null && !terminateMappingNodes.isNull()) {
            documentNode.set("terminatePlanItemDefinitions", (JsonNode)terminateMappingNodes);
        }
        if ((moveToAvailableMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonMoveToAvailablePlanItemDefinitionMappings(caseInstanceMigrationDocument.getMoveToAvailablePlanItemDefinitionMappings())) != null && !moveToAvailableMappingNodes.isNull()) {
            documentNode.set("moveToAvailablePlanItemDefinitions", (JsonNode)moveToAvailableMappingNodes);
        }
        if ((waitingForRepetitionMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonWaitingForRepetitionPlanItemDefinitionMappings(caseInstanceMigrationDocument.getWaitingForRepetitionPlanItemDefinitionMappings())) != null && !waitingForRepetitionMappingNodes.isNull()) {
            documentNode.set("waitingForRepetitionPlanItemDefinitions", (JsonNode)waitingForRepetitionMappingNodes);
        }
        if ((removeWaitingForRepetitionMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonRemoveWaitingForRepetitionPlanItemDefinitionMappings(caseInstanceMigrationDocument.getRemoveWaitingForRepetitionPlanItemDefinitionMappings())) != null && !removeWaitingForRepetitionMappingNodes.isNull()) {
            documentNode.set("removeWaitingForRepetitionPlanItemDefinitions", (JsonNode)removeWaitingForRepetitionMappingNodes);
        }
        if ((changePlanItemIdMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonChangePlanItemIdMappings(caseInstanceMigrationDocument.getChangePlanItemIdMappings())) != null && !changePlanItemIdMappingNodes.isNull()) {
            documentNode.set("changePlanItemIds", (JsonNode)changePlanItemIdMappingNodes);
        }
        if ((changePlanItemIdWithDefinitionIdMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonChangePlanItemIdWithDefinitionIdMappings(caseInstanceMigrationDocument.getChangePlanItemIdWithDefinitionIdMappings())) != null && !changePlanItemIdWithDefinitionIdMappingNodes.isNull()) {
            documentNode.set("changePlanItemIdsWithDefinitionId", (JsonNode)changePlanItemIdWithDefinitionIdMappingNodes);
        }
        if ((changePlanItemDefinitionWithNewTargetIdsMappingNodes = CaseInstanceMigrationDocumentConverter.convertToJsonChangePlanItemDefinitionWithNewTargetIdsMappings(caseInstanceMigrationDocument.getChangePlanItemDefinitionWithNewTargetIdsMappings())) != null && !changePlanItemDefinitionWithNewTargetIdsMappingNodes.isNull()) {
            documentNode.set("changePlanItemDefinitionWithNewTargetIds", (JsonNode)changePlanItemDefinitionWithNewTargetIdsMappingNodes);
        }
        if (caseInstanceMigrationDocument.getPreUpgradeExpression() != null) {
            documentNode.put("preUpgradeExpression", caseInstanceMigrationDocument.getPreUpgradeExpression());
        }
        if (caseInstanceMigrationDocument.getPostUpgradeExpression() != null) {
            documentNode.put("postUpgradeExpression", caseInstanceMigrationDocument.getPostUpgradeExpression());
        }
        if ((caseInstanceVariablesNode = CaseInstanceMigrationDocumentConverter.convertToJsonCaseInstanceVariables(caseInstanceMigrationDocument, objectMapper)) != null && !caseInstanceVariablesNode.isNull()) {
            documentNode.set("caseInstanceVariables", caseInstanceVariablesNode);
        }
        return documentNode;
    }

    public static String convertToJsonString(CaseInstanceMigrationDocument caseInstanceMigrationDocument) {
        JsonNode jsonNode = CaseInstanceMigrationDocumentConverter.convertToJson(caseInstanceMigrationDocument);
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        try {
            return objectWriter.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            return jsonNode.toString();
        }
    }

    protected static ArrayNode convertToJsonActivatePlanItemDefinitionMappings(List<ActivatePlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (ActivatePlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingNode.put("newAssignee", mapping.getNewAssignee());
            mappingNode.put("condition", mapping.getCondition());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonTerminatePlanItemDefinitionMappings(List<TerminatePlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (TerminatePlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingNode.put("condition", mapping.getCondition());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonMoveToAvailablePlanItemDefinitionMappings(List<MoveToAvailablePlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (MoveToAvailablePlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingNode.put("condition", mapping.getCondition());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonWaitingForRepetitionPlanItemDefinitionMappings(List<WaitingForRepetitionPlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (WaitingForRepetitionPlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingNode.put("condition", mapping.getCondition());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonRemoveWaitingForRepetitionPlanItemDefinitionMappings(List<RemoveWaitingForRepetitionPlanItemDefinitionMapping> planItemDefinitionMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (RemoveWaitingForRepetitionPlanItemDefinitionMapping mapping : planItemDefinitionMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("planItemDefinitionId", mapping.getPlanItemDefinitionId());
            mappingNode.put("condition", mapping.getCondition());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonChangePlanItemIdMappings(List<ChangePlanItemIdMapping> planItemIdMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (ChangePlanItemIdMapping mapping : planItemIdMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("existingPlanItemId", mapping.getExistingPlanItemId());
            mappingNode.put("newPlanItemId", mapping.getNewPlanItemId());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonChangePlanItemIdWithDefinitionIdMappings(List<ChangePlanItemIdWithDefinitionIdMapping> definitionIdMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (ChangePlanItemIdWithDefinitionIdMapping mapping : definitionIdMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("existingPlanItemDefinitionId", mapping.getExistingPlanItemDefinitionId());
            mappingNode.put("newPlanItemDefinitionId", mapping.getNewPlanItemDefinitionId());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    protected static ArrayNode convertToJsonChangePlanItemDefinitionWithNewTargetIdsMappings(List<ChangePlanItemDefinitionWithNewTargetIdsMapping> definitionIdMappings) {
        ArrayNode mappingsArray = objectMapper.createArrayNode();
        for (ChangePlanItemDefinitionWithNewTargetIdsMapping mapping : definitionIdMappings) {
            ObjectNode mappingNode = objectMapper.createObjectNode();
            mappingNode.put("existingPlanItemDefinitionId", mapping.getExistingPlanItemDefinitionId());
            mappingNode.put("newPlanItemId", mapping.getNewPlanItemId());
            mappingNode.put("newPlanItemDefinitionId", mapping.getNewPlanItemDefinitionId());
            mappingsArray.add((JsonNode)mappingNode);
        }
        return mappingsArray;
    }

    public static CaseInstanceMigrationDocument convertFromJson(String jsonCaseInstanceMigrationDocument) {
        try {
            JsonNode caseInstanceVariablesNode;
            JsonNode changePlanItemDefinitionWithNewTargetIdsMappingNodes;
            JsonNode changePlanItemIdWithDefinitionIdMappingNodes;
            JsonNode changePlanItemIdMappingNodes;
            JsonNode removeWaitingForRepetitionMappingNodes;
            JsonNode waitingForRepetitionMappingNodes;
            JsonNode moveToAvailableMappingNodes;
            JsonNode terminateMappingNodes;
            String condition;
            JsonNode rootNode = objectMapper.readTree(jsonCaseInstanceMigrationDocument);
            CaseInstanceMigrationDocumentBuilderImpl documentBuilder = new CaseInstanceMigrationDocumentBuilderImpl();
            documentBuilder.setCaseDefinitionToMigrateTo(CaseInstanceMigrationDocumentConverter.getJsonProperty("toCaseDefinitionId", rootNode));
            String caseDefinitionKey = CaseInstanceMigrationDocumentConverter.getJsonProperty("toCaseDefinitionKey", rootNode);
            Integer caseDefinitionVersion = CaseInstanceMigrationDocumentConverter.getJsonPropertyAsInteger("toCaseDefinitionVersion", rootNode);
            documentBuilder.setCaseDefinitionToMigrateTo(caseDefinitionKey, caseDefinitionVersion);
            documentBuilder.setTenantId(CaseInstanceMigrationDocumentConverter.getJsonProperty("toCaseDefinitionTenantId", rootNode));
            JsonNode activateMappingNodes = rootNode.get("activatePlanItemDefinitions");
            if (activateMappingNodes != null) {
                for (Iterator mappingNode : activateMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", (JsonNode)mappingNode);
                    ActivatePlanItemDefinitionMapping activateDefinitionMapping = new ActivatePlanItemDefinitionMapping(planItemDefinitionId);
                    String newAssginee = CaseInstanceMigrationDocumentConverter.getJsonProperty("newAssignee", (JsonNode)mappingNode);
                    activateDefinitionMapping.setNewAssignee(newAssginee);
                    condition = CaseInstanceMigrationDocumentConverter.getJsonProperty("condition", (JsonNode)mappingNode);
                    activateDefinitionMapping.setCondition(condition);
                    documentBuilder.addActivatePlanItemDefinitionMapping(activateDefinitionMapping);
                }
            }
            if ((terminateMappingNodes = rootNode.get("terminatePlanItemDefinitions")) != null) {
                for (Iterator mappingNode : terminateMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", (JsonNode)mappingNode);
                    TerminatePlanItemDefinitionMapping terminateDefinitionMapping = new TerminatePlanItemDefinitionMapping(planItemDefinitionId);
                    condition = CaseInstanceMigrationDocumentConverter.getJsonProperty("condition", (JsonNode)mappingNode);
                    terminateDefinitionMapping.setCondition(condition);
                    documentBuilder.addTerminatePlanItemDefinitionMapping(terminateDefinitionMapping);
                }
            }
            if ((moveToAvailableMappingNodes = rootNode.get("moveToAvailablePlanItemDefinitions")) != null) {
                for (Iterator mappingNode : moveToAvailableMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", (JsonNode)mappingNode);
                    MoveToAvailablePlanItemDefinitionMapping moveToAvailableDefinitionMapping = new MoveToAvailablePlanItemDefinitionMapping(planItemDefinitionId);
                    String condition2 = CaseInstanceMigrationDocumentConverter.getJsonProperty("condition", (JsonNode)mappingNode);
                    moveToAvailableDefinitionMapping.setCondition(condition2);
                    documentBuilder.addMoveToAvailablePlanItemDefinitionMapping(moveToAvailableDefinitionMapping);
                }
            }
            if ((waitingForRepetitionMappingNodes = rootNode.get("waitingForRepetitionPlanItemDefinitions")) != null) {
                for (Iterator mappingNode : waitingForRepetitionMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", (JsonNode)mappingNode);
                    WaitingForRepetitionPlanItemDefinitionMapping waitingForRepetitionDefinitionMapping = new WaitingForRepetitionPlanItemDefinitionMapping(planItemDefinitionId);
                    String condition3 = CaseInstanceMigrationDocumentConverter.getJsonProperty("condition", (JsonNode)mappingNode);
                    waitingForRepetitionDefinitionMapping.setCondition(condition3);
                    documentBuilder.addWaitingForRepetitionPlanItemDefinitionMapping(waitingForRepetitionDefinitionMapping);
                }
            }
            if ((removeWaitingForRepetitionMappingNodes = rootNode.get("removeWaitingForRepetitionPlanItemDefinitions")) != null) {
                for (Iterator mappingNode : removeWaitingForRepetitionMappingNodes) {
                    String planItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("planItemDefinitionId", (JsonNode)mappingNode);
                    RemoveWaitingForRepetitionPlanItemDefinitionMapping removeWaitingForRepetitionDefinitionMapping = new RemoveWaitingForRepetitionPlanItemDefinitionMapping(planItemDefinitionId);
                    String condition4 = CaseInstanceMigrationDocumentConverter.getJsonProperty("condition", (JsonNode)mappingNode);
                    removeWaitingForRepetitionDefinitionMapping.setCondition(condition4);
                    documentBuilder.addRemoveWaitingForRepetitionPlanItemDefinitionMapping(removeWaitingForRepetitionDefinitionMapping);
                }
            }
            if ((changePlanItemIdMappingNodes = rootNode.get("changePlanItemIds")) != null) {
                for (Iterator mappingNode : changePlanItemIdMappingNodes) {
                    String existingPlanItemId = CaseInstanceMigrationDocumentConverter.getJsonProperty("existingPlanItemId", (JsonNode)mappingNode);
                    String newPlanItemId = CaseInstanceMigrationDocumentConverter.getJsonProperty("newPlanItemId", (JsonNode)mappingNode);
                    ChangePlanItemIdMapping changePlanItemIdMapping = new ChangePlanItemIdMapping(existingPlanItemId, newPlanItemId);
                    documentBuilder.addChangePlanItemIdMapping(changePlanItemIdMapping);
                }
            }
            if ((changePlanItemIdWithDefinitionIdMappingNodes = rootNode.get("changePlanItemIdsWithDefinitionId")) != null) {
                for (Iterator mappingNode : changePlanItemIdWithDefinitionIdMappingNodes) {
                    String existingPlanItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("existingPlanItemDefinitionId", (JsonNode)mappingNode);
                    String newPlanItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("newPlanItemDefinitionId", (JsonNode)mappingNode);
                    ChangePlanItemIdWithDefinitionIdMapping changePlanItemIdWithDefinitionIdMapping = new ChangePlanItemIdWithDefinitionIdMapping(existingPlanItemDefinitionId, newPlanItemDefinitionId);
                    documentBuilder.addChangePlanItemIdWithDefinitionIdMapping(changePlanItemIdWithDefinitionIdMapping);
                }
            }
            if ((changePlanItemDefinitionWithNewTargetIdsMappingNodes = rootNode.get("changePlanItemDefinitionWithNewTargetIds")) != null) {
                for (JsonNode mappingNode : changePlanItemDefinitionWithNewTargetIdsMappingNodes) {
                    String existingPlanItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("existingPlanItemDefinitionId", mappingNode);
                    String newPlanItemId = CaseInstanceMigrationDocumentConverter.getJsonProperty("newPlanItemId", mappingNode);
                    String newPlanItemDefinitionId = CaseInstanceMigrationDocumentConverter.getJsonProperty("newPlanItemDefinitionId", mappingNode);
                    ChangePlanItemDefinitionWithNewTargetIdsMapping changePlanItemDefinitionWithNewTargetIdsMapping = new ChangePlanItemDefinitionWithNewTargetIdsMapping(existingPlanItemDefinitionId, newPlanItemId, newPlanItemDefinitionId);
                    documentBuilder.addChangePlanItemDefinitionWithNewTargetIdsMapping(changePlanItemDefinitionWithNewTargetIdsMapping);
                }
            }
            if ((caseInstanceVariablesNode = rootNode.get("caseInstanceVariables")) != null) {
                Map caseInstanceVariables = (Map)CaseInstanceMigrationDocumentConverter.convertFromJsonNodeToObject(caseInstanceVariablesNode, objectMapper);
                documentBuilder.addCaseInstanceVariables(caseInstanceVariables);
            }
            String preUpgradeExpression = CaseInstanceMigrationDocumentConverter.getJsonProperty("preUpgradeExpression", rootNode);
            documentBuilder.preUpgradeExpression(preUpgradeExpression);
            String postUpgradeExpression = CaseInstanceMigrationDocumentConverter.getJsonProperty("postUpgradeExpression", rootNode);
            documentBuilder.postUpgradeExpression(postUpgradeExpression);
            return documentBuilder.build();
        }
        catch (IOException e) {
            throw new FlowableException("Error parsing Case Instance Migration Document", (Throwable)e);
        }
    }

    protected static JsonNode convertToJsonCaseInstanceVariables(CaseInstanceMigrationDocument caseInstanceMigrationDocument, ObjectMapper objectMapper) {
        Map caseInstanceVariables = caseInstanceMigrationDocument.getCaseInstanceVariables();
        if (caseInstanceVariables != null && !caseInstanceVariables.isEmpty()) {
            return objectMapper.valueToTree((Object)caseInstanceVariables);
        }
        return null;
    }

    protected static <T> T convertFromJsonNodeToObject(JsonNode jsonNode, ObjectMapper objectMapper) {
        return (T)objectMapper.convertValue((Object)jsonNode, new TypeReference<T>(){});
    }

    protected static String getJsonProperty(String propertyName, JsonNode jsonNode) {
        if (jsonNode.has(propertyName) && !jsonNode.get(propertyName).isNull()) {
            return jsonNode.get(propertyName).asText();
        }
        return null;
    }

    protected static Integer getJsonPropertyAsInteger(String propertyName, JsonNode jsonNode) {
        if (jsonNode.has(propertyName) && !jsonNode.get(propertyName).isNull()) {
            return jsonNode.get(propertyName).asInt();
        }
        return null;
    }
}

