/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.caze;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryProperty;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.engine.variable.QueryVariable;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstancePaginateList;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstanceQueryRequest;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstanceResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseCaseInstanceResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected CmmnRuntimeService runtimeService;

    protected DataResponse<CaseInstanceResponse> getQueryResponse(CaseInstanceQueryRequest queryRequest, Map<String, String> requestParams) {
        CaseInstanceQuery query = this.runtimeService.createCaseInstanceQuery();
        if (queryRequest.getCaseInstanceId() != null) {
            query.caseInstanceId(queryRequest.getCaseInstanceId());
        }
        if (queryRequest.getCaseDefinitionKey() != null) {
            query.caseDefinitionKey(queryRequest.getCaseDefinitionKey());
        }
        if (queryRequest.getCaseDefinitionId() != null) {
            query.caseDefinitionId(queryRequest.getCaseDefinitionId());
        }
        if (queryRequest.getCaseBusinessKey() != null) {
            query.caseInstanceBusinessKey(queryRequest.getCaseBusinessKey());
        }
        if (queryRequest.getInvolvedUser() != null) {
            // empty if block
        }
        if (queryRequest.getCaseInstanceParentId() != null) {
            query.caseInstanceParentId(queryRequest.getCaseInstanceParentId());
        }
        if (queryRequest.getIncludeCaseVariables() == null || queryRequest.getIncludeCaseVariables().booleanValue()) {
            // empty if block
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        if (queryRequest.getTenantId() != null) {
            query.caseInstanceTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.caseInstanceTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.caseInstanceWithoutTenantId();
        }
        return new CaseInstancePaginateList(this.restResponseFactory).paginateList(requestParams, queryRequest, (Query)query, "id", allowedSortProperties);
    }

    protected void addVariables(CaseInstanceQuery caseInstanceQuery, List<QueryVariable> variables) {
        block11: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess && variable.getVariableOperation() != QueryVariable.QueryVariableOperation.EQUALS) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is only supported when using 'equals' operation.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    if (nameLess) {
                        caseInstanceQuery.variableValueEquals(actualValue);
                        continue block11;
                    }
                    caseInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        caseInstanceQuery.variableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    caseInstanceQuery.variableValueNotEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        caseInstanceQuery.variableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case LIKE: {
                    if (actualValue instanceof String) {
                        caseInstanceQuery.variableValueLike(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported for like, but was: " + actualValue.getClass().getName());
                }
                case GREATER_THAN: {
                    caseInstanceQuery.variableValueGreaterThan(variable.getName(), actualValue);
                    continue block11;
                }
                case GREATER_THAN_OR_EQUALS: {
                    caseInstanceQuery.variableValueGreaterThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN: {
                    caseInstanceQuery.variableValueLessThan(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN_OR_EQUALS: {
                    caseInstanceQuery.variableValueLessThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    protected CaseInstance getCaseInstanceFromRequest(String caseInstanceId) {
        CaseInstance caseInstance = (CaseInstance)this.runtimeService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a case instance with id '" + caseInstanceId + "'.");
        }
        return caseInstance;
    }

    static {
        allowedSortProperties.put("caseDefinitionId", (QueryProperty)CaseInstanceQueryProperty.CASE_DEFINITION_ID);
        allowedSortProperties.put("caseDefinitionKey", (QueryProperty)CaseInstanceQueryProperty.CASE_DEFINITION_KEY);
        allowedSortProperties.put("id", (QueryProperty)CaseInstanceQueryProperty.CASE_INSTANCE_ID);
        allowedSortProperties.put("tenantId", (QueryProperty)CaseInstanceQueryProperty.TENANT_ID);
    }
}

