/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.spring.configurator;

import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.configurator.CmmnEngineConfigurator;
import org.flowable.cmmn.spring.SpringCmmnEngineConfiguration;
import org.flowable.cmmn.spring.SpringCmmnExpressionManager;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.spring.SpringProcessEngineConfiguration;

public class SpringCmmnEngineConfigurator
extends CmmnEngineConfigurator {
    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.cmmnEngineConfiguration == null) {
            this.cmmnEngineConfiguration = new SpringCmmnEngineConfiguration();
        }
        if (!(this.cmmnEngineConfiguration instanceof SpringCmmnEngineConfiguration)) {
            throw new FlowableException("SpringCmmnEngineConfigurator accepts only SpringCmmnEngineConfiguration. " + this.cmmnEngineConfiguration.getClass().getName());
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.cmmnEngineConfiguration);
        SpringEngineConfiguration springEngineConfiguration = (SpringEngineConfiguration)engineConfiguration;
        SpringProcessEngineConfiguration springProcessEngineConfiguration = null;
        if (springEngineConfiguration instanceof SpringProcessEngineConfiguration) {
            springProcessEngineConfiguration = (SpringProcessEngineConfiguration)springEngineConfiguration;
        } else {
            AbstractEngineConfiguration processEngineConfiguration = (AbstractEngineConfiguration)engineConfiguration.getEngineConfigurations().get("cfg.processEngine");
            if (processEngineConfiguration instanceof SpringProcessEngineConfiguration) {
                springProcessEngineConfiguration = (SpringProcessEngineConfiguration)processEngineConfiguration;
            }
        }
        if (springProcessEngineConfiguration != null) {
            this.initProcessInstanceService((ProcessEngineConfigurationImpl)springProcessEngineConfiguration);
            this.initProcessInstanceStateChangedCallbacks((ProcessEngineConfigurationImpl)springProcessEngineConfiguration);
            this.cmmnEngineConfiguration.setEnableTaskRelationshipCounts(springProcessEngineConfiguration.getPerformanceSettings().isEnableTaskRelationshipCounts());
            this.cmmnEngineConfiguration.setTaskQueryLimit(springProcessEngineConfiguration.getTaskQueryLimit());
            this.cmmnEngineConfiguration.setHistoricTaskQueryLimit(springProcessEngineConfiguration.getHistoricTaskQueryLimit());
        }
        ((SpringCmmnEngineConfiguration)this.cmmnEngineConfiguration).setTransactionManager(springEngineConfiguration.getTransactionManager());
        this.cmmnEngineConfiguration.setExpressionManager((ExpressionManager)new SpringCmmnExpressionManager(springEngineConfiguration.getApplicationContext(), springEngineConfiguration.getBeans()));
        this.initCmmnEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.cmmnEngineConfiguration);
    }

    protected synchronized CmmnEngine initCmmnEngine() {
        if (this.cmmnEngineConfiguration == null) {
            throw new FlowableException("CmmnEngineConfiguration is required");
        }
        return this.cmmnEngineConfiguration.buildCmmnEngine();
    }

    public SpringCmmnEngineConfiguration getCmmnEngineConfiguration() {
        return (SpringCmmnEngineConfiguration)this.cmmnEngineConfiguration;
    }

    public SpringCmmnEngineConfigurator setCmmnEngineConfiguration(SpringCmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
        return this;
    }
}

