/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentObject;
import org.flowable.content.api.ContentStorage;
import org.flowable.content.engine.impl.interceptor.Command;
import org.flowable.content.engine.impl.interceptor.CommandContext;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;

public class GetContentItemStreamCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String contentItemId;

    public GetContentItemStreamCmd(String contentItemId) {
        this.contentItemId = contentItemId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        if (this.contentItemId == null) {
            throw new FlowableIllegalArgumentException("contentItemId is null");
        }
        ContentItem contentItem = (ContentItem)commandContext.getContentItemEntityManager().findById(this.contentItemId);
        if (contentItem == null) {
            throw new FlowableObjectNotFoundException("content item could not be found with id " + this.contentItemId);
        }
        ContentStorage contentStorage = commandContext.getContentEngineConfiguration().getContentStorage();
        ContentObject contentObject = contentStorage.getContentObject(contentItem.getContentStoreId());
        return contentObject.getContent();
    }
}

