/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.fs;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.content.api.ContentObject;
import org.flowable.content.api.ContentStorage;
import org.flowable.content.api.ContentStorageException;
import org.flowable.content.engine.impl.fs.FileSystemContentObject;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileSystemContentStorage
implements ContentStorage {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleFileSystemContentStorage.class);
    private static TimeBasedGenerator UUID_GENERATOR = Generators.timeBasedGenerator((EthernetAddress)EthernetAddress.fromInterface());
    private static final String TEMP_SUFFIX = "_TEMP";
    private static final String OLD_SUFFIX = "_OLD";
    public static final String TYPE_TASK = "task-content";
    public static final String TYPE_PROCESS_INSTANCE = "process-instance-content";
    public static final String TYPE_UNCATEGORIZED = "uncategorized";
    public static final String TASK_PREFIX = "task";
    public static final String PROCESS_INSTANCE_PREFIX = "proc";
    public static final String UNCATEGORIZED_PREFIX = "uncategorized";
    protected File contentFolderRoot;
    protected File taskFolder;
    protected File processInstanceFolder;
    protected File uncategorizedFolder;

    public SimpleFileSystemContentStorage(File contentFolderRoot) {
        this.contentFolderRoot = contentFolderRoot;
        this.validateOrCreateSubfolders();
    }

    protected void validateOrCreateSubfolders() {
        this.taskFolder = this.validateOrCreateFolder(TYPE_TASK);
        this.processInstanceFolder = this.validateOrCreateFolder(TYPE_PROCESS_INSTANCE);
        this.uncategorizedFolder = this.validateOrCreateFolder("uncategorized");
    }

    protected File validateOrCreateFolder(String folderName) {
        File subFolder = new File(this.contentFolderRoot, folderName);
        if (!subFolder.exists()) {
            boolean created = subFolder.mkdir();
            if (created) {
                LOG.info("Created content folder in {}", (Object)subFolder.getAbsolutePath());
            } else {
                LOG.warn("Could not create content folder. This might impact the storage of related content");
            }
        }
        return subFolder;
    }

    public ContentObject createContentObject(InputStream contentStream, Map<String, Object> metaData) {
        String uuid = UUID_GENERATOR.generate().toString();
        File file = this.getContentFile(metaData, uuid);
        try {
            long length = IOUtils.copy((InputStream)contentStream, (OutputStream)new FileOutputStream(file, false));
            String contentId = this.generateContentId(uuid, metaData);
            return new FileSystemContentObject(file, contentId, length);
        }
        catch (IOException e) {
            throw new ContentStorageException("Could not write content to " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    protected String generateContentId(String uuid, Map<String, Object> metaData) {
        String contentId = "";
        switch (this.determineType(metaData)) {
            case "process-instance-content": {
                String processInstanceId = (String)metaData.get("processInstanceId");
                contentId = "proc." + processInstanceId;
                break;
            }
            case "task-content": {
                String taskId = (String)metaData.get("taskId");
                contentId = "task." + taskId;
                break;
            }
            default: {
                contentId = "uncategorized";
            }
        }
        contentId = contentId + "." + uuid;
        return contentId;
    }

    public ContentObject updateContentObject(String id, InputStream contentStream, Map<String, Object> metaData) {
        long length;
        File contentFile;
        block13: {
            contentFile = this.getContentFile(id);
            File tempContentFile = new File(contentFile.getParentFile(), id + TEMP_SUFFIX);
            File oldContentFile = new File(contentFile.getParentFile(), id + OLD_SUFFIX);
            boolean tempFileCreated = false;
            length = -1L;
            try {
                if (!tempContentFile.createNewFile()) {
                    throw new ContentStorageException("Cannot update content with id: " + id + ", being updated by another user");
                }
                tempFileCreated = true;
                FileOutputStream tempOutputStream = new FileOutputStream(tempContentFile);
                length = IOUtils.copy((InputStream)contentStream, (OutputStream)tempOutputStream);
                IOUtils.closeQuietly((OutputStream)tempOutputStream);
                if (contentFile.renameTo(oldContentFile)) {
                    if (tempContentFile.renameTo(contentFile)) {
                        oldContentFile.delete();
                        break block13;
                    }
                    oldContentFile.renameTo(contentFile);
                    throw new ContentStorageException("Error while renaming new content file, content not updated");
                }
                throw new ContentStorageException("Error while renaming existing content file, content not updated");
            }
            catch (IOException ioe) {
                throw new ContentStorageException("Error while updating content with id: " + id, (Throwable)ioe);
            }
            finally {
                if (tempFileCreated) {
                    try {
                        tempContentFile.delete();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return new FileSystemContentObject(contentFile, id, length);
    }

    public ContentObject getContentObject(String id) {
        return new FileSystemContentObject(this.getContentFile(id), id);
    }

    protected File getContentFile(String id) {
        String[] ids = id.split("\\.");
        String type = ids[0];
        if (PROCESS_INSTANCE_PREFIX.equals(type) || TASK_PREFIX.equals(type)) {
            File subFolder = PROCESS_INSTANCE_PREFIX.equals(type) ? this.processInstanceFolder : this.taskFolder;
            File idFolder = new File(subFolder, ids[1]);
            File contentFile = new File(idFolder, ids[2]);
            return contentFile;
        }
        if ("uncategorized".equals(type)) {
            File contentFile = new File(this.uncategorizedFolder, ids[1]);
            return contentFile;
        }
        throw new FlowableObjectNotFoundException("No content found for id " + id);
    }

    public Map<String, Object> getMetaData() {
        return null;
    }

    public void deleteContentObject(String id) {
        try {
            File contentFile = this.getContentFile(id);
            File parentFile = contentFile.getParentFile();
            contentFile.delete();
            if (parentFile.listFiles().length == 0) {
                parentFile.delete();
            }
        }
        catch (Exception e) {
            throw new ContentStorageException("Error while deleting content", (Throwable)e);
        }
    }

    public String getContentStoreName() {
        return "file";
    }

    protected File getContentFile(Map<String, Object> metaData, String contentId) {
        return new File(this.createOrGetFolderBasedOnMetaData(metaData), contentId);
    }

    protected String determineType(Map<String, Object> metaData) {
        String processInstanceId = (String)metaData.get("processInstanceId");
        if (StringUtils.isNotEmpty((CharSequence)processInstanceId)) {
            return TYPE_PROCESS_INSTANCE;
        }
        String taskId = (String)metaData.get("taskId");
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            return TYPE_TASK;
        }
        return "uncategorized";
    }

    protected File createOrGetFolderBasedOnMetaData(Map<String, Object> metaData) {
        switch (this.determineType(metaData)) {
            case "process-instance-content": {
                String processInstanceId = (String)metaData.get("processInstanceId");
                return this.internalCreateOrGetFolder(this.processInstanceFolder, processInstanceId);
            }
            case "task-content": {
                String taskId = (String)metaData.get("taskId");
                return this.internalCreateOrGetFolder(this.taskFolder, taskId);
            }
        }
        return this.uncategorizedFolder;
    }

    protected File internalCreateOrGetFolder(File parentFolder, String id) {
        File folder = new File(parentFolder, id);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }
}

