/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.flowable.content.api.ContentManagementService;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.impl.db.DbSqlSession;
import org.flowable.content.engine.impl.interceptor.Command;
import org.flowable.content.engine.impl.interceptor.CommandContext;
import org.flowable.content.engine.impl.interceptor.CommandExecutor;
import org.flowable.content.engine.impl.test.AbstractContentTestCase;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.junit.Assert;

public abstract class AbstractFlowableTestCase
extends AbstractContentTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = new ArrayList<String>();
    protected ContentEngine contentEngine;
    protected Throwable exception;
    protected ContentEngineConfiguration contentEngineConfiguration;
    protected ContentManagementService managementService;
    protected ContentService contentService;

    protected abstract void initializeContentEngine();

    protected void closeDownContentEngine() {
    }

    protected void nullifyServices() {
        this.contentEngineConfiguration = null;
        this.managementService = null;
        this.contentService = null;
    }

    public void runBare() throws Throwable {
        this.initializeContentEngine();
        if (this.contentService == null) {
            this.initializeServices();
        }
        try {
            super.runBare();
        }
        catch (AssertionFailedError e) {
            log.error("\n");
            log.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            log.error("\n");
            log.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            this.assertAndEnsureCleanDb();
            this.contentEngineConfiguration.getClock().reset();
            this.closeDownContentEngine();
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        log.debug("verifying that db is clean after test");
        Map tableCounts = this.managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(this.contentEngineConfiguration.getDatabaseTablePrefix(), "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = (Long)tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            log.error("\n");
            log.error(outputMessage.toString());
            log.info("dropping and recreating db");
            CommandExecutor commandExecutor = this.contentEngine.getContentEngineConfiguration().getCommandExecutor();
            CommandConfig config = new CommandConfig().transactionNotSupported();
            commandExecutor.execute(config, new Command<Object>(){

                @Override
                public Object execute(CommandContext commandContext) {
                    DbSqlSession session = commandContext.getDbSqlSession();
                    session.dbSchemaDrop();
                    session.dbSchemaCreate();
                    return null;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            Assert.fail((String)outputMessage.toString());
        } else {
            log.info("database was clean");
        }
    }

    protected void initializeServices() {
        this.contentEngineConfiguration = this.contentEngine.getContentEngineConfiguration();
        this.managementService = this.contentEngine.getContentManagementService();
        this.contentService = this.contentEngine.getContentService();
    }

    static {
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_CO_DATABASECHANGELOG");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_CO_DATABASECHANGELOGLOCK");
    }
}

