/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.flowable.dmn.api.ExpressionExecution;

public class RuleExecutionAuditContainer {
    protected Date startTime;
    protected Date endTime;
    protected int ruleNumber;
    protected Boolean valid = Boolean.FALSE;
    @JsonProperty(value="exception")
    protected String exceptionMessage;
    protected Map<Integer, ExpressionExecution> conditionResults = new HashMap<Integer, ExpressionExecution>();
    protected Map<Integer, ExpressionExecution> conclusionResults = new HashMap<Integer, ExpressionExecution>();

    public RuleExecutionAuditContainer(int ruleNumber) {
        this.ruleNumber = ruleNumber;
        this.startTime = new Date();
    }

    public void addConditionResult(int inputNumber, ExpressionExecution expressionExecution) {
        this.conditionResults.put(inputNumber, expressionExecution);
    }

    public void addConclusionResult(int outputNumber, ExpressionExecution executionResult) {
        this.conclusionResults.put(outputNumber, executionResult);
    }

    public void markRuleEnd() {
        this.endTime = new Date();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getRuleNumber() {
        return this.ruleNumber;
    }

    public Boolean isValid() {
        return this.valid;
    }

    public void setValid() {
        this.valid = Boolean.TRUE;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public Map<Integer, ExpressionExecution> getConditionResults() {
        return this.conditionResults;
    }

    public Map<Integer, ExpressionExecution> getConclusionResults() {
        return this.conclusionResults;
    }
}

