/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.xml.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.dmn.converter.util.DmnXMLUtil;
import org.flowable.dmn.model.BuiltinAggregator;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.DmnExtensionElement;
import org.flowable.dmn.model.Expression;
import org.flowable.dmn.model.HitPolicy;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.ItemDefinition;
import org.flowable.dmn.model.RuleInputClauseContainer;
import org.flowable.dmn.xml.constants.DmnXMLConstants;
import org.flowable.dmn.xml.converter.BaseDmnXMLConverter;
import org.flowable.dmn.xml.converter.DecisionRuleXMLConverter;
import org.flowable.dmn.xml.converter.IndentingXMLStreamWriter;
import org.flowable.dmn.xml.converter.InputClauseXMLConverter;
import org.flowable.dmn.xml.converter.OutputClauseXMLConverter;
import org.flowable.dmn.xml.exception.DmnXMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DmnXMLConverter
implements DmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DmnXMLConverter.class);
    protected static final String DMN_XSD = "org/flowable/impl/dmn/parser/dmn.xsd";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static Map<String, BaseDmnXMLConverter> convertersToDmnMap = new HashMap<String, BaseDmnXMLConverter>();
    protected static Map<Class<? extends DmnElement>, BaseDmnXMLConverter> convertersToXMLMap = new HashMap<Class<? extends DmnElement>, BaseDmnXMLConverter>();
    protected ClassLoader classloader;

    public static void addConverter(BaseDmnXMLConverter converter) {
        DmnXMLConverter.addConverter(converter, converter.getDmnElementType());
    }

    public static void addConverter(BaseDmnXMLConverter converter, Class<? extends DmnElement> elementType) {
        convertersToDmnMap.put(converter.getXMLElementName(), converter);
        convertersToXMLMap.put(elementType, converter);
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public void validateModel(InputStreamProvider inputStreamProvider) throws Exception {
        Schema schema = this.createSchema();
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(inputStreamProvider.getInputStream()));
    }

    public void validateModel(XMLStreamReader xmlStreamReader) throws Exception {
        Schema schema = this.createSchema();
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(xmlStreamReader));
    }

    protected Schema createSchema() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        if (this.classloader != null) {
            schema = factory.newSchema(this.classloader.getResource(DMN_XSD));
        }
        if (schema == null) {
            schema = factory.newSchema(DmnXMLConverter.class.getClassLoader().getResource(DMN_XSD));
        }
        if (schema == null) {
            throw new DmnXMLException("DMN XSD could not be found");
        }
        return schema;
    }

    public DmnDefinition convertToDmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeBpmnXml) {
        return this.convertToDmnModel(inputStreamProvider, validateSchema, enableSafeBpmnXml, DEFAULT_ENCODING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DmnDefinition convertToDmnModel(InputStreamProvider inputStreamProvider, boolean validateSchema, boolean enableSafeBpmnXml, String encoding) {
        Throwable throwable;
        InputStreamReader in;
        XMLInputFactory xif = XMLInputFactory.newInstance();
        if (xif.isPropertySupported("javax.xml.stream.isReplacingEntityReferences")) {
            xif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.isSupportingExternalEntities")) {
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        if (xif.isPropertySupported("javax.xml.stream.supportDTD")) {
            xif.setProperty("javax.xml.stream.supportDTD", false);
        }
        if (validateSchema) {
            try {
                in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
                throwable = null;
                try {
                    if (!enableSafeBpmnXml) {
                        this.validateModel(inputStreamProvider);
                    } else {
                        this.validateModel(xif.createXMLStreamReader(in));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new DmnXMLException("The dmn xml is not properly encoded", e);
            }
            catch (XMLStreamException e) {
                throw new DmnXMLException("Error while reading the dmn xml file", e);
            }
            catch (Exception e) {
                throw new DmnXMLException(e.getMessage(), e);
            }
        }
        try {
            in = new InputStreamReader(inputStreamProvider.getInputStream(), encoding);
            throwable = null;
            try {
                DmnDefinition dmnDefinition = this.convertToDmnModel(xif.createXMLStreamReader(in));
                return dmnDefinition;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DmnXMLException("The dmn xml is not properly encoded", e);
        }
        catch (XMLStreamException e) {
            throw new DmnXMLException("Error while reading the dmn xml file", e);
        }
        catch (IOException e) {
            throw new DmnXMLException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DmnDefinition convertToDmnModel(XMLStreamReader xtr) {
        DmnDefinition model = new DmnDefinition();
        DmnDefinition parentElement = null;
        DecisionTable currentDecisionTable = null;
        convertersToDmnMap.get("rule").initializeElementCounter();
        convertersToDmnMap.get("input").initializeElementCounter();
        convertersToDmnMap.get("output").initializeElementCounter();
        try {
            block5: while (xtr.hasNext()) {
                try {
                    xtr.next();
                }
                catch (Exception e) {
                    LOGGER.debug("Error reading XML document", (Throwable)e);
                    throw new DmnXMLException("Error reading XML", e);
                }
                if (!xtr.isStartElement()) continue;
                if ("definitions".equals(xtr.getLocalName())) {
                    model.setId(xtr.getAttributeValue(null, "id"));
                    model.setName(xtr.getAttributeValue(null, "name"));
                    model.setNamespace("http://www.flowable.org/dmn");
                    parentElement = model;
                    continue;
                }
                if ("decision".equals(xtr.getLocalName())) {
                    Decision decision = new Decision();
                    model.addDecision(decision);
                    decision.setId(xtr.getAttributeValue(null, "id"));
                    decision.setName(xtr.getAttributeValue(null, "name"));
                    parentElement = decision;
                    continue;
                }
                if ("decisionTable".equals(xtr.getLocalName())) {
                    currentDecisionTable = new DecisionTable();
                    currentDecisionTable.setId(xtr.getAttributeValue(null, "id"));
                    if (xtr.getAttributeValue(null, "hitPolicy") != null) {
                        currentDecisionTable.setHitPolicy(HitPolicy.get((String)xtr.getAttributeValue(null, "hitPolicy")));
                    } else {
                        currentDecisionTable.setHitPolicy(HitPolicy.FIRST);
                    }
                    if (xtr.getAttributeValue(null, "aggregation") != null) {
                        currentDecisionTable.setAggregation(BuiltinAggregator.get((String)xtr.getAttributeValue(null, "aggregation")));
                    }
                    ((Decision)model.getDecisions().get(model.getDecisions().size() - 1)).setExpression((Expression)currentDecisionTable);
                    parentElement = currentDecisionTable;
                    continue;
                }
                if ("description".equals(xtr.getLocalName())) {
                    parentElement.setDescription(xtr.getElementText());
                    continue;
                }
                if (!"extensionElements".equals(xtr.getLocalName())) {
                    if (!convertersToDmnMap.containsKey(xtr.getLocalName())) continue;
                    BaseDmnXMLConverter converter = convertersToDmnMap.get(xtr.getLocalName());
                    converter.convertToDmnModel(xtr, model, currentDecisionTable);
                    continue;
                }
                while (xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement()) {
                        DmnExtensionElement extensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                        parentElement.addExtensionElement(extensionElement);
                        continue;
                    }
                    if (!xtr.isEndElement() || !"extensionElements".equals(xtr.getLocalName())) continue;
                    continue block5;
                }
            }
            return model;
        }
        catch (DmnXMLException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error processing DMN document", (Throwable)e);
            throw new DmnXMLException("Error processing DMN document", e);
        }
    }

    public byte[] convertToXML(DmnDefinition model) {
        return this.convertToXML(model, DEFAULT_ENCODING);
    }

    public byte[] convertToXML(DmnDefinition model, String encoding) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, encoding);
            XMLStreamWriter writer = xof.createXMLStreamWriter(out);
            IndentingXMLStreamWriter xtw = new IndentingXMLStreamWriter(writer);
            xtw.writeStartElement("definitions");
            xtw.writeDefaultNamespace("http://www.omg.org/spec/DMN/20151101");
            xtw.writeAttribute("id", model.getId());
            if (StringUtils.isNotEmpty((CharSequence)model.getName())) {
                xtw.writeAttribute("name", model.getName());
            }
            xtw.writeAttribute("namespace", "http://www.flowable.org/dmn");
            DmnXMLUtil.writeElementDescription((DmnElement)model, xtw);
            DmnXMLUtil.writeExtensionElements((DmnElement)model, xtw);
            for (ItemDefinition itemDefinition : model.getItemDefinitions()) {
                xtw.writeStartElement("itemDefinition");
                xtw.writeAttribute("id", itemDefinition.getId());
                if (StringUtils.isNotEmpty((CharSequence)itemDefinition.getName())) {
                    xtw.writeAttribute("name", itemDefinition.getName());
                }
                DmnXMLUtil.writeElementDescription((DmnElement)itemDefinition, xtw);
                DmnXMLUtil.writeExtensionElements((DmnElement)itemDefinition, xtw);
                xtw.writeStartElement("typeDefinition");
                xtw.writeCharacters(itemDefinition.getTypeDefinition());
                xtw.writeEndElement();
                xtw.writeEndElement();
            }
            for (Decision decision : model.getDecisions()) {
                xtw.writeStartElement("decision");
                xtw.writeAttribute("id", decision.getId());
                if (StringUtils.isNotEmpty((CharSequence)decision.getName())) {
                    xtw.writeAttribute("name", decision.getName());
                }
                DmnXMLUtil.writeElementDescription((DmnElement)decision, xtw);
                DmnXMLUtil.writeExtensionElements((DmnElement)decision, xtw);
                DecisionTable decisionTable = (DecisionTable)decision.getExpression();
                xtw.writeStartElement("decisionTable");
                xtw.writeAttribute("id", decisionTable.getId());
                if (decisionTable.getHitPolicy() != null) {
                    xtw.writeAttribute("hitPolicy", decisionTable.getHitPolicy().getValue());
                }
                if (decisionTable.getAggregation() != null) {
                    xtw.writeAttribute("aggregation", decisionTable.getAggregation().toString());
                }
                DmnXMLUtil.writeElementDescription((DmnElement)decisionTable, xtw);
                DmnXMLUtil.writeExtensionElements((DmnElement)decisionTable, xtw);
                for (InputClause clause : decisionTable.getInputs()) {
                    xtw.writeStartElement("input");
                    if (StringUtils.isNotEmpty((CharSequence)clause.getId())) {
                        xtw.writeAttribute("id", clause.getId());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)clause.getLabel())) {
                        xtw.writeAttribute("label", clause.getLabel());
                    }
                    DmnXMLUtil.writeElementDescription((DmnElement)clause, xtw);
                    DmnXMLUtil.writeExtensionElements((DmnElement)clause, xtw);
                    if (clause.getInputExpression() != null) {
                        xtw.writeStartElement("inputExpression");
                        xtw.writeAttribute("id", clause.getInputExpression().getId());
                        if (StringUtils.isNotEmpty((CharSequence)clause.getInputExpression().getTypeRef())) {
                            xtw.writeAttribute("typeRef", clause.getInputExpression().getTypeRef());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)clause.getInputExpression().getText())) {
                            xtw.writeStartElement("text");
                            xtw.writeCharacters(clause.getInputExpression().getText());
                            xtw.writeEndElement();
                        }
                        xtw.writeEndElement();
                    }
                    if (clause.getInputValues() != null && StringUtils.isNotEmpty((CharSequence)clause.getInputValues().getText())) {
                        xtw.writeStartElement("inputValues");
                        xtw.writeStartElement("text");
                        xtw.writeCharacters(clause.getInputValues().getText());
                        xtw.writeEndElement();
                        xtw.writeEndElement();
                    }
                    xtw.writeEndElement();
                }
                for (InputClause clause : decisionTable.getOutputs()) {
                    xtw.writeStartElement("output");
                    if (StringUtils.isNotEmpty((CharSequence)clause.getId())) {
                        xtw.writeAttribute("id", clause.getId());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)clause.getLabel())) {
                        xtw.writeAttribute("label", clause.getLabel());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)clause.getName())) {
                        xtw.writeAttribute("name", clause.getName());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)clause.getTypeRef())) {
                        xtw.writeAttribute("typeRef", clause.getTypeRef());
                    }
                    if (clause.getOutputValues() != null && StringUtils.isNotEmpty((CharSequence)clause.getOutputValues().getText())) {
                        xtw.writeStartElement("outputValues");
                        xtw.writeStartElement("text");
                        xtw.writeCharacters(clause.getOutputValues().getText());
                        xtw.writeEndElement();
                        xtw.writeEndElement();
                    }
                    DmnXMLUtil.writeElementDescription((DmnElement)clause, xtw);
                    DmnXMLUtil.writeExtensionElements((DmnElement)clause, xtw);
                    xtw.writeEndElement();
                }
                for (DecisionRule rule : decisionTable.getRules()) {
                    xtw.writeStartElement("rule");
                    if (StringUtils.isNotEmpty((CharSequence)rule.getId())) {
                        xtw.writeAttribute("id", rule.getId());
                    }
                    DmnXMLUtil.writeElementDescription((DmnElement)rule, xtw);
                    DmnXMLUtil.writeExtensionElements((DmnElement)rule, xtw);
                    for (RuleInputClauseContainer container : rule.getInputEntries()) {
                        xtw.writeStartElement("inputEntry");
                        xtw.writeAttribute("id", container.getInputEntry().getId());
                        DmnXMLUtil.writeExtensionElements((DmnElement)container.getInputEntry(), xtw);
                        xtw.writeStartElement("text");
                        xtw.writeCData(container.getInputEntry().getText());
                        xtw.writeEndElement();
                        xtw.writeEndElement();
                    }
                    for (RuleInputClauseContainer container : rule.getOutputEntries()) {
                        xtw.writeStartElement("outputEntry");
                        xtw.writeAttribute("id", container.getOutputEntry().getId());
                        xtw.writeStartElement("text");
                        xtw.writeCData(container.getOutputEntry().getText());
                        xtw.writeEndElement();
                        xtw.writeEndElement();
                    }
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
            xtw.writeEndDocument();
            xtw.flush();
            outputStream.close();
            xtw.close();
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error("Error writing BPMN XML", (Throwable)e);
            throw new DmnXMLException("Error writing BPMN XML", e);
        }
    }

    static {
        DmnXMLConverter.addConverter(new InputClauseXMLConverter());
        DmnXMLConverter.addConverter(new OutputClauseXMLConverter());
        DmnXMLConverter.addConverter(new DecisionRuleXMLConverter());
    }
}

