/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.LinkedList;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.agenda.ContinueMultiInstanceOperation;
import org.flowable.engine.impl.agenda.ContinueProcessOperation;
import org.flowable.engine.impl.agenda.DestroyScopeOperation;
import org.flowable.engine.impl.agenda.EndExecutionOperation;
import org.flowable.engine.impl.agenda.ExecuteInactiveBehaviorsOperation;
import org.flowable.engine.impl.agenda.TakeOutgoingSequenceFlowsOperation;
import org.flowable.engine.impl.agenda.TriggerExecutionOperation;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlowableEngineAgenda
implements FlowableEngineAgenda {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFlowableEngineAgenda.class);
    protected CommandContext commandContext;
    protected LinkedList<Runnable> operations = new LinkedList();

    public DefaultFlowableEngineAgenda(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    @Override
    public Runnable getNextOperation() {
        this.assertOperationsNotEmpty();
        return this.operations.poll();
    }

    @Override
    public Runnable peekOperation() {
        this.assertOperationsNotEmpty();
        return this.operations.peek();
    }

    private void assertOperationsNotEmpty() {
        if (this.operations.isEmpty()) {
            throw new FlowableException("Unable to peek empty agenda.");
        }
    }

    @Override
    public void planOperation(Runnable operation) {
        this.planOperation(operation, null);
    }

    @Override
    public void planOperation(Runnable operation, ExecutionEntity executionEntity) {
        this.operations.add(operation);
        logger.debug("Operation {} added to agenda", operation.getClass());
        if (executionEntity != null) {
            this.commandContext.addInvolvedExecution(executionEntity);
        }
    }

    @Override
    public void planContinueProcessOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution), execution);
    }

    @Override
    public void planContinueProcessSynchronousOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution, true, false), execution);
    }

    @Override
    public void planContinueProcessInCompensation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution, false, true), execution);
    }

    @Override
    public void planContinueMultiInstanceOperation(ExecutionEntity execution, int loopCounter) {
        this.planOperation(new ContinueMultiInstanceOperation(this.commandContext, execution, loopCounter), execution);
    }

    @Override
    public void planTakeOutgoingSequenceFlowsOperation(ExecutionEntity execution, boolean evaluateConditions) {
        this.planOperation(new TakeOutgoingSequenceFlowsOperation(this.commandContext, execution, evaluateConditions), execution);
    }

    @Override
    public void planEndExecutionOperation(ExecutionEntity execution) {
        this.planOperation(new EndExecutionOperation(this.commandContext, execution), execution);
    }

    @Override
    public void planTriggerExecutionOperation(ExecutionEntity execution) {
        this.planOperation(new TriggerExecutionOperation(this.commandContext, execution), execution);
    }

    @Override
    public void planDestroyScopeOperation(ExecutionEntity execution) {
        this.planOperation(new DestroyScopeOperation(this.commandContext, execution), execution);
    }

    @Override
    public void planExecuteInactiveBehaviorsOperation() {
        this.planOperation(new ExecuteInactiveBehaviorsOperation(this.commandContext));
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setCommandContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public LinkedList<Runnable> getOperations() {
        return this.operations;
    }
}

