/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ScopeUtil;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;

public class BoundaryCancelEventActivityBehavior
extends BoundaryEventActivityBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        DelegateExecution subProcessExecution = null;
        List<ExecutionEntity> processInstanceExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
        for (ExecutionEntity childExecution : processInstanceExecutions) {
            if (childExecution.getCurrentFlowElement() == null || !childExecution.getCurrentFlowElement().getId().equals(boundaryEvent.getAttachedToRefId())) continue;
            subProcessExecution = childExecution;
            break;
        }
        if (subProcessExecution == null) {
            throw new FlowableException("No execution found for sub process of boundary cancel event " + boundaryEvent.getId());
        }
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        List<CompensateEventSubscriptionEntity> eventSubscriptions = eventSubscriptionEntityManager.findCompensateEventSubscriptionsByExecutionId(subProcessExecution.getParentId());
        if (eventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            Activity activity;
            String deleteReason = "boundary event(" + boundaryEvent.getId() + ")";
            ScopeUtil.throwCompensationEvent(eventSubscriptions, execution, false);
            executionEntityManager.deleteExecutionAndRelatedData((ExecutionEntity)subProcessExecution, deleteReason, false);
            if (subProcessExecution.getCurrentFlowElement() instanceof Activity && (activity = (Activity)subProcessExecution.getCurrentFlowElement()).getLoopCharacteristics() != null) {
                ExecutionEntity miExecution = subProcessExecution.getParent();
                List<ExecutionEntity> miChildExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(miExecution.getId());
                for (ExecutionEntity miChildExecution : miChildExecutions) {
                    if (subProcessExecution.getId().equals(miChildExecution.getId()) || !activity.getId().equals(miChildExecution.getCurrentActivityId())) continue;
                    executionEntityManager.deleteExecutionAndRelatedData(miChildExecution, deleteReason, false);
                }
            }
            this.leave(execution);
        }
    }
}

