/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.impl.ProcessDefinitionQueryImpl;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;

public class ChangeDeploymentTenantIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newTenantId;

    public ChangeDeploymentTenantIdCmd(String deploymentId, String newTenantId) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        DeploymentEntity deployment = (DeploymentEntity)commandContext.getDeploymentEntityManager().findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find deployment with id " + this.deploymentId, Deployment.class);
        }
        if (Flowable5Util.isFlowable5Deployment((Deployment)deployment, commandContext)) {
            commandContext.getProcessEngineConfiguration().getFlowable5CompatibilityHandler().changeDeploymentTenantId(this.deploymentId, this.newTenantId);
            return null;
        }
        String oldTenantId = deployment.getTenantId();
        deployment.setTenantId(this.newTenantId);
        commandContext.getProcessDefinitionEntityManager().updateProcessDefinitionTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getExecutionEntityManager().updateExecutionTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getTaskEntityManager().updateTaskTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getJobEntityManager().updateJobTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getTimerJobEntityManager().updateJobTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getSuspendedJobEntityManager().updateJobTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getDeadLetterJobEntityManager().updateJobTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getEventSubscriptionEntityManager().updateEventSubscriptionTenantId(oldTenantId, this.newTenantId);
        List processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(this.deploymentId).list();
        for (ProcessDefinition processDefinition : processDefinitions) {
            commandContext.getProcessEngineConfiguration().getProcessDefinitionCache().remove(processDefinition.getId());
        }
        commandContext.getProcessEngineConfiguration().getProcessDefinitionCache().clear();
        return null;
    }
}

