/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.Flowable5Util;

public class MessageEventReceivedCmd
extends NeedsActiveExecutionCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected final Map<String, Object> payload;
    protected final String messageName;
    protected final boolean async;

    public MessageEventReceivedCmd(String messageName, String executionId, Map<String, Object> processVariables) {
        super(executionId);
        this.messageName = messageName;
        this.payload = processVariables != null ? new HashMap<String, Object>(processVariables) : null;
        this.async = false;
    }

    public MessageEventReceivedCmd(String messageName, String executionId, boolean async) {
        super(executionId);
        this.messageName = messageName;
        this.payload = null;
        this.async = async;
    }

    @Override
    protected Void execute(CommandContext commandContext, ExecutionEntity execution) {
        if (this.messageName == null) {
            throw new FlowableIllegalArgumentException("messageName cannot be null");
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.messageEventReceived(this.messageName, this.executionId, this.payload, this.async);
            return null;
        }
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        List<EventSubscriptionEntity> eventSubscriptions = eventSubscriptionEntityManager.findEventSubscriptionsByNameAndExecution("message", this.messageName, this.executionId);
        if (eventSubscriptions.isEmpty()) {
            throw new FlowableException("Execution with id '" + this.executionId + "' does not have a subscription to a message event with name '" + this.messageName + "'");
        }
        EventSubscriptionEntity eventSubscriptionEntity = eventSubscriptions.get(0);
        eventSubscriptionEntityManager.eventReceived(eventSubscriptionEntity, this.payload, this.async);
        return null;
    }
}

