/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.db;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.flowable.engine.common.impl.db.AbstractDbSqlSession;
import org.flowable.engine.common.impl.db.AbstractDbSqlSessionFactory;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.db.DbSqlSession;
import org.flowable.engine.impl.db.EntityDependencyOrder;
import org.flowable.engine.impl.persistence.entity.EventLogEntryEntityImpl;

public class DbSqlSessionFactory
extends AbstractDbSqlSessionFactory {
    protected Map<Class<? extends Entity>, Boolean> bulkInsertableMap;
    protected Map<Class<?>, String> bulkInsertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> bulkDeleteStatements = new ConcurrentHashMap();
    protected int maxNrOfStatementsInBulkInsert = 100;

    public Class<?> getSessionType() {
        return DbSqlSession.class;
    }

    protected AbstractDbSqlSession createDbSqlSession() {
        return new DbSqlSession(this, Context.getCommandContext().getEntityCache());
    }

    public void setBulkInsertEnabled(boolean isBulkInsertEnabled, String databaseType) {
        if (isBulkInsertEnabled) {
            this.initBulkInsertEnabledMap(databaseType);
        }
    }

    protected void initBulkInsertEnabledMap(String databaseType) {
        this.bulkInsertableMap = new HashMap<Class<? extends Entity>, Boolean>();
        for (Class<? extends Entity> clazz : EntityDependencyOrder.INSERT_ORDER) {
            this.bulkInsertableMap.put(clazz, Boolean.TRUE);
        }
        if ("oracle".equals(databaseType)) {
            this.bulkInsertableMap.put(EventLogEntryEntityImpl.class, Boolean.FALSE);
        }
    }

    public Boolean isBulkInsertable(Class<? extends Entity> entityClass) {
        return this.bulkInsertableMap != null && this.bulkInsertableMap.containsKey(entityClass) && this.bulkInsertableMap.get(entityClass) != false;
    }

    public Map<Class<? extends Entity>, Boolean> getBulkInsertableMap() {
        return this.bulkInsertableMap;
    }

    public String getBulkInsertStatement(Class clazz) {
        return this.getStatement(clazz, this.bulkInsertStatements, "bulkInsert");
    }

    public String getBulkDeleteStatement(Class<?> entityClass) {
        return this.getStatement(entityClass, this.bulkDeleteStatements, "bulkDelete");
    }

    public void setBulkInsertableMap(Map<Class<? extends Entity>, Boolean> bulkInsertableMap) {
        this.bulkInsertableMap = bulkInsertableMap;
    }

    public int getMaxNrOfStatementsInBulkInsert() {
        return this.maxNrOfStatementsInBulkInsert;
    }

    public void setMaxNrOfStatementsInBulkInsert(int maxNrOfStatementsInBulkInsert) {
        this.maxNrOfStatementsInBulkInsert = maxNrOfStatementsInBulkInsert;
    }

    public Map<Class<?>, String> getBulkInsertStatements() {
        return this.bulkInsertStatements;
    }

    public void setBulkInsertStatements(Map<Class<?>, String> bulkInsertStatements) {
        this.bulkInsertStatements = bulkInsertStatements;
    }

    public Map<Class<?>, String> getBulkDeleteStatements() {
        return this.bulkDeleteStatements;
    }

    public void setBulkDeleteStatements(Map<Class<?>, String> bulkDeleteStatements) {
        this.bulkDeleteStatements = bulkDeleteStatements;
    }
}

