/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.impl.RuntimeServiceImpl;
import org.flowable.engine.runtime.ChangeActivityStateBuilder;

public class ChangeActivityStateBuilderImpl
implements ChangeActivityStateBuilder {
    protected RuntimeServiceImpl runtimeService;
    protected String processInstanceId;
    protected List<MoveExecutionIdContainer> moveExecutionIdList = new ArrayList<MoveExecutionIdContainer>();
    protected List<MoveActivityIdContainer> moveActivityIdList = new ArrayList<MoveActivityIdContainer>();
    protected Map<String, Object> processVariables;
    protected Map<String, Map<String, Object>> localVariables;

    public ChangeActivityStateBuilderImpl(RuntimeServiceImpl runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Override
    public ChangeActivityStateBuilder processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public ChangeActivityStateBuilder moveExecutionToActivityId(String executionId, String activityId) {
        this.moveExecutionIdList.add(new MoveExecutionIdContainer(executionId, activityId));
        return this;
    }

    @Override
    public ChangeActivityStateBuilder moveExecutionsToSingleActivityId(List<String> executionIds, String activityId) {
        this.moveExecutionIdList.add(new MoveExecutionIdContainer(executionIds, activityId));
        return this;
    }

    @Override
    public ChangeActivityStateBuilder moveSingleExecutionToActivityIds(String executionId, List<String> activityIds) {
        this.moveExecutionIdList.add(new MoveExecutionIdContainer(executionId, activityIds));
        return this;
    }

    @Override
    public ChangeActivityStateBuilder moveActivityIdTo(String currentActivityId, String newActivityId) {
        this.moveActivityIdList.add(new MoveActivityIdContainer(currentActivityId, newActivityId));
        return this;
    }

    @Override
    public ChangeActivityStateBuilder moveActivityIdsToSingleActivityId(List<String> activityIds, String activityId) {
        this.moveActivityIdList.add(new MoveActivityIdContainer(activityIds, activityId));
        return this;
    }

    @Override
    public ChangeActivityStateBuilder moveSingleActivityIdToActivityIds(String currentActivityId, List<String> newActivityIds) {
        this.moveActivityIdList.add(new MoveActivityIdContainer(currentActivityId, newActivityIds));
        return this;
    }

    @Override
    public ChangeActivityStateBuilder moveActivityIdToParentActivityId(String currentActivityId, String newActivityId) {
        MoveActivityIdContainer moveActivityIdContainer = new MoveActivityIdContainer(currentActivityId, newActivityId);
        moveActivityIdContainer.setMoveToParentProcess(true);
        this.moveActivityIdList.add(moveActivityIdContainer);
        return this;
    }

    @Override
    public ChangeActivityStateBuilder moveActivityIdToSubProcessInstanceActivityId(String currentActivityId, String newActivityId, String callActivityId) {
        MoveActivityIdContainer moveActivityIdContainer = new MoveActivityIdContainer(currentActivityId, newActivityId);
        moveActivityIdContainer.setMoveToSubProcessInstance(true);
        moveActivityIdContainer.setCallActivityId(callActivityId);
        this.moveActivityIdList.add(moveActivityIdContainer);
        return this;
    }

    @Override
    public ChangeActivityStateBuilder processVariable(String processVariableName, Object processVariableValue) {
        if (this.processVariables == null) {
            this.processVariables = new HashMap<String, Object>();
        }
        this.processVariables.put(processVariableName, processVariableValue);
        return this;
    }

    @Override
    public ChangeActivityStateBuilder processVariables(Map<String, Object> processVariables) {
        this.processVariables = processVariables;
        return this;
    }

    @Override
    public ChangeActivityStateBuilder localVariable(String startActivityId, String localVariableName, Object localVariableValue) {
        if (this.localVariables == null) {
            this.localVariables = new HashMap<String, Map<String, Object>>();
        }
        Map<String, Object> localVariableMap = null;
        localVariableMap = this.localVariables.containsKey(startActivityId) ? this.localVariables.get(startActivityId) : new HashMap<String, Object>();
        localVariableMap.put(localVariableName, localVariableValue);
        this.localVariables.put(startActivityId, localVariableMap);
        return this;
    }

    @Override
    public ChangeActivityStateBuilder localVariables(String startActivityId, Map<String, Object> localVariables) {
        if (this.localVariables == null) {
            this.localVariables = new HashMap<String, Map<String, Object>>();
        }
        this.localVariables.put(startActivityId, localVariables);
        return this;
    }

    @Override
    public void changeState() {
        this.runtimeService.changeActivityState(this);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public List<MoveExecutionIdContainer> getMoveExecutionIdList() {
        return this.moveExecutionIdList;
    }

    public List<MoveActivityIdContainer> getMoveActivityIdList() {
        return this.moveActivityIdList;
    }

    public Map<String, Object> getProcessVariables() {
        return this.processVariables;
    }

    public Map<String, Map<String, Object>> getLocalVariables() {
        return this.localVariables;
    }

    public class MoveActivityIdContainer {
        protected List<String> activityIds;
        protected String singleActivityId;
        protected String moveToActivityId;
        protected List<String> moveToActivityIds;
        protected boolean moveToParentProcess;
        protected boolean moveToSubProcessInstance;
        protected String callActivityId;

        public MoveActivityIdContainer(String singleActivityId, String moveToActivityId) {
            this.singleActivityId = singleActivityId;
            this.moveToActivityId = moveToActivityId;
        }

        public MoveActivityIdContainer(List<String> activityIds, String moveToActivityId) {
            this.activityIds = activityIds;
            this.moveToActivityId = moveToActivityId;
        }

        public MoveActivityIdContainer(String singleActivityId, List<String> moveToActivityIds) {
            this.singleActivityId = singleActivityId;
            this.moveToActivityIds = moveToActivityIds;
        }

        public List<String> getActivityIds() {
            if (this.singleActivityId != null) {
                return Collections.singletonList(this.singleActivityId);
            }
            if (this.activityIds != null) {
                return this.activityIds;
            }
            return new ArrayList<String>();
        }

        public List<String> getMoveToActivityIds() {
            if (this.moveToActivityId != null) {
                return Collections.singletonList(this.moveToActivityId);
            }
            if (this.moveToActivityIds != null) {
                return this.moveToActivityIds;
            }
            return new ArrayList<String>();
        }

        public boolean isMoveToParentProcess() {
            return this.moveToParentProcess;
        }

        public void setMoveToParentProcess(boolean moveToParentProcess) {
            this.moveToParentProcess = moveToParentProcess;
        }

        public boolean isMoveToSubProcessInstance() {
            return this.moveToSubProcessInstance;
        }

        public void setMoveToSubProcessInstance(boolean moveToSubProcessInstance) {
            this.moveToSubProcessInstance = moveToSubProcessInstance;
        }

        public String getCallActivityId() {
            return this.callActivityId;
        }

        public void setCallActivityId(String callActivityId) {
            this.callActivityId = callActivityId;
        }
    }

    public class MoveExecutionIdContainer {
        protected List<String> executionIds;
        protected String singleExecutionId;
        protected String moveToActivityId;
        protected List<String> moveToActivityIds;

        public MoveExecutionIdContainer(String singleExecutionId, String moveToActivityId) {
            this.singleExecutionId = singleExecutionId;
            this.moveToActivityId = moveToActivityId;
        }

        public MoveExecutionIdContainer(List<String> executionIds, String moveToActivityId) {
            this.executionIds = executionIds;
            this.moveToActivityId = moveToActivityId;
        }

        public MoveExecutionIdContainer(String singleExecutionId, List<String> moveToActivityIds) {
            this.singleExecutionId = singleExecutionId;
            this.moveToActivityIds = moveToActivityIds;
        }

        public List<String> getExecutionIds() {
            if (this.singleExecutionId != null) {
                return Collections.singletonList(this.singleExecutionId);
            }
            if (this.executionIds != null) {
                return this.executionIds;
            }
            return new ArrayList<String>();
        }

        public List<String> getMoveToActivityIds() {
            if (this.moveToActivityId != null) {
                return Collections.singletonList(this.moveToActivityId);
            }
            if (this.moveToActivityIds != null) {
                return this.moveToActivityIds;
            }
            return new ArrayList<String>();
        }
    }
}

