/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util.condition;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.Condition;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.el.UelExpressionCondition;
import org.flowable.engine.impl.scripting.ScriptCondition;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ConditionUtil {
    public static boolean hasTrueCondition(SequenceFlow sequenceFlow, DelegateExecution execution) {
        String conditionExpression = null;
        if (CommandContextUtil.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode elementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(sequenceFlow.getId(), execution.getProcessDefinitionId());
            conditionExpression = ConditionUtil.getActiveValue(sequenceFlow.getConditionExpression(), "sequenceFlowCondition", elementProperties);
        } else {
            conditionExpression = sequenceFlow.getConditionExpression();
        }
        if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
            String conditionLanguage = sequenceFlow.getConditionLanguage();
            return ConditionUtil.hasTrueCondition(sequenceFlow.getId(), conditionExpression, conditionLanguage, execution);
        }
        return true;
    }

    public static boolean hasTrueCondition(String elementId, String conditionExpression, String conditionLanguage, DelegateExecution execution) {
        Condition condition;
        if (conditionLanguage == null) {
            Expression expression = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager().createExpression(conditionExpression);
            condition = new UelExpressionCondition(expression);
        } else {
            condition = new ScriptCondition(conditionExpression, conditionLanguage);
        }
        return condition.evaluate(elementId, execution);
    }

    protected static String getActiveValue(String originalValue, String propertyName, ObjectNode elementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (elementProperties != null && (overrideValueNode = elementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }
}

