/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.flowable.eventregistry.impl;

import java.util.Collections;
import java.util.Map;

import org.flowable.eventregistry.api.OutboundEvent;
import org.flowable.eventregistry.api.runtime.EventInstance;

/**
 * @author Filip Hrisafov
 */
public class DefaultOutboundEvent<T> implements OutboundEvent<T> {

    protected final T body;
    protected final EventInstance eventInstance;
    protected final Map<String, Object> headers;

    public DefaultOutboundEvent(T body, EventInstance eventInstance) {
        this(body, eventInstance, Collections.emptyMap());
    }

    public DefaultOutboundEvent(T body, EventInstance eventInstance, Map<String, Object> headers) {
        this.body = body;
        this.eventInstance = eventInstance;
        this.headers = headers;
    }

    @Override
    public T getBody() {
        return body;
    }

    @Override
    public Map<String, Object> getHeaders() {
        return headers;
    }

    @Override
    public EventInstance getEventInstance() {
        return eventInstance;
    }
}
