/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.flowable.editor.form.converter.FormJsonConverter;
import org.flowable.engine.common.AbstractEngineConfiguration;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.cfg.BeansConfigurationHelper;
import org.flowable.engine.common.impl.cfg.TransactionContextFactory;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.SessionFactory;
import org.flowable.engine.common.runtime.Clock;
import org.flowable.form.api.FormManagementService;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.impl.FormEngineImpl;
import org.flowable.form.engine.impl.FormManagementServiceImpl;
import org.flowable.form.engine.impl.FormRepositoryServiceImpl;
import org.flowable.form.engine.impl.FormServiceImpl;
import org.flowable.form.engine.impl.ServiceImpl;
import org.flowable.form.engine.impl.cfg.CommandExecutorImpl;
import org.flowable.form.engine.impl.cfg.StandaloneFormEngineConfiguration;
import org.flowable.form.engine.impl.cfg.StandaloneInMemFormEngineConfiguration;
import org.flowable.form.engine.impl.cfg.TransactionListener;
import org.flowable.form.engine.impl.cfg.standalone.StandaloneMybatisTransactionContextFactory;
import org.flowable.form.engine.impl.db.DbSqlSessionFactory;
import org.flowable.form.engine.impl.deployer.CachingAndArtifactsManager;
import org.flowable.form.engine.impl.deployer.FormDefinitionDeployer;
import org.flowable.form.engine.impl.deployer.FormDefinitionDeploymentHelper;
import org.flowable.form.engine.impl.deployer.ParsedDeploymentBuilderFactory;
import org.flowable.form.engine.impl.el.ExpressionManager;
import org.flowable.form.engine.impl.interceptor.CommandContext;
import org.flowable.form.engine.impl.interceptor.CommandContextFactory;
import org.flowable.form.engine.impl.interceptor.CommandContextInterceptor;
import org.flowable.form.engine.impl.interceptor.CommandExecutor;
import org.flowable.form.engine.impl.interceptor.CommandInterceptor;
import org.flowable.form.engine.impl.interceptor.CommandInvoker;
import org.flowable.form.engine.impl.interceptor.LogInterceptor;
import org.flowable.form.engine.impl.interceptor.TransactionContextInterceptor;
import org.flowable.form.engine.impl.parser.FormDefinitionParseFactory;
import org.flowable.form.engine.impl.persistence.deploy.DefaultDeploymentCache;
import org.flowable.form.engine.impl.persistence.deploy.Deployer;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityManagerImpl;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntityManagerImpl;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntityManagerImpl;
import org.flowable.form.engine.impl.persistence.entity.ResourceEntityManager;
import org.flowable.form.engine.impl.persistence.entity.ResourceEntityManagerImpl;
import org.flowable.form.engine.impl.persistence.entity.TableDataManager;
import org.flowable.form.engine.impl.persistence.entity.TableDataManagerImpl;
import org.flowable.form.engine.impl.persistence.entity.data.FormDefinitionDataManager;
import org.flowable.form.engine.impl.persistence.entity.data.FormDeploymentDataManager;
import org.flowable.form.engine.impl.persistence.entity.data.FormInstanceDataManager;
import org.flowable.form.engine.impl.persistence.entity.data.ResourceDataManager;
import org.flowable.form.engine.impl.persistence.entity.data.impl.MybatisFormDefinitionDataManager;
import org.flowable.form.engine.impl.persistence.entity.data.impl.MybatisFormDeploymentDataManager;
import org.flowable.form.engine.impl.persistence.entity.data.impl.MybatisFormInstanceDataManager;
import org.flowable.form.engine.impl.persistence.entity.data.impl.MybatisResourceDataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormEngineConfiguration
extends AbstractEngineConfiguration {
    protected static final Logger logger = LoggerFactory.getLogger(FormEngineConfiguration.class);
    public static final String DEFAULT_MYBATIS_MAPPING_FILE = "org/flowable/form/db/mapping/mappings.xml";
    public static final String LIQUIBASE_CHANGELOG_PREFIX = "ACT_FO_";
    protected String formEngineName = "default";
    protected CommandInterceptor commandInvoker;
    protected List<CommandInterceptor> customPreCommandInterceptors;
    protected List<CommandInterceptor> customPostCommandInterceptors;
    protected List<CommandInterceptor> commandInterceptors;
    protected CommandExecutor commandExecutor;
    protected FormManagementService formManagementService = new FormManagementServiceImpl();
    protected FormRepositoryService formRepositoryService = new FormRepositoryServiceImpl();
    protected FormService formService = new FormServiceImpl();
    protected FormDeploymentDataManager deploymentDataManager;
    protected FormDefinitionDataManager formDefinitionDataManager;
    protected ResourceDataManager resourceDataManager;
    protected FormInstanceDataManager formInstanceDataManager;
    protected FormDeploymentEntityManager deploymentEntityManager;
    protected FormDefinitionEntityManager formDefinitionEntityManager;
    protected ResourceEntityManager resourceEntityManager;
    protected FormInstanceEntityManager formInstanceEntityManager;
    protected TableDataManager tableDataManager;
    protected CommandContextFactory commandContextFactory;
    protected TransactionContextFactory<TransactionListener, CommandContext> transactionContextFactory;
    protected ExpressionManager expressionManager;
    protected FormJsonConverter formJsonConverter = new FormJsonConverter();
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected FormDefinitionDeployer formDeployer;
    protected FormDefinitionParseFactory formParseFactory;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected FormDefinitionDeploymentHelper formDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;
    protected List<Deployer> customPreDeployers;
    protected List<Deployer> customPostDeployers;
    protected List<Deployer> deployers;
    protected DeploymentManager deploymentManager;
    protected int formDefinitionCacheLimit = -1;
    protected DeploymentCache<FormDefinitionCacheEntry> formDefinitionCache;

    public static FormEngineConfiguration createFormEngineConfigurationFromResourceDefault() {
        return FormEngineConfiguration.createFormEngineConfigurationFromResource("flowable.form.cfg.xml", "formEngineConfiguration");
    }

    public static FormEngineConfiguration createFormEngineConfigurationFromResource(String resource) {
        return FormEngineConfiguration.createFormEngineConfigurationFromResource(resource, "formEngineConfiguration");
    }

    public static FormEngineConfiguration createFormEngineConfigurationFromResource(String resource, String beanName) {
        return (FormEngineConfiguration)BeansConfigurationHelper.parseEngineConfigurationFromResource((String)resource, (String)beanName);
    }

    public static FormEngineConfiguration createFormEngineConfigurationFromInputStream(InputStream inputStream) {
        return FormEngineConfiguration.createFormEngineConfigurationFromInputStream(inputStream, "formEngineConfiguration");
    }

    public static FormEngineConfiguration createFormEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        return (FormEngineConfiguration)BeansConfigurationHelper.parseEngineConfigurationFromInputStream((InputStream)inputStream, (String)beanName);
    }

    public static FormEngineConfiguration createStandaloneFormEngineConfiguration() {
        return new StandaloneFormEngineConfiguration();
    }

    public static FormEngineConfiguration createStandaloneInMemFormEngineConfiguration() {
        return new StandaloneInMemFormEngineConfiguration();
    }

    public FormEngine buildFormEngine() {
        this.init();
        return new FormEngineImpl(this);
    }

    protected void init() {
        this.initExpressionManager();
        this.initCommandContextFactory();
        this.initTransactionContextFactory();
        this.initCommandExecutors();
        this.initIdGenerator();
        if (this.usingRelationalDatabase) {
            this.initDataSource();
            this.initDbSchema();
        }
        this.initBeans();
        this.initTransactionFactory();
        this.initSqlSessionFactory();
        this.initSessionFactories();
        this.initServices();
        this.initDataManagers();
        this.initEntityManagers();
        this.initDeployers();
        this.initClock();
    }

    protected void initServices() {
        this.initService(this.formManagementService);
        this.initService(this.formRepositoryService);
        this.initService(this.formService);
    }

    protected void initService(Object service) {
        if (service instanceof ServiceImpl) {
            ((ServiceImpl)service).setCommandExecutor(this.commandExecutor);
        }
    }

    public void initExpressionManager() {
        if (this.expressionManager == null) {
            this.expressionManager = new ExpressionManager();
        }
    }

    public void initDataManagers() {
        if (this.deploymentDataManager == null) {
            this.deploymentDataManager = new MybatisFormDeploymentDataManager(this);
        }
        if (this.formDefinitionDataManager == null) {
            this.formDefinitionDataManager = new MybatisFormDefinitionDataManager(this);
        }
        if (this.resourceDataManager == null) {
            this.resourceDataManager = new MybatisResourceDataManager(this);
        }
        if (this.formInstanceDataManager == null) {
            this.formInstanceDataManager = new MybatisFormInstanceDataManager(this);
        }
    }

    public void initEntityManagers() {
        if (this.deploymentEntityManager == null) {
            this.deploymentEntityManager = new FormDeploymentEntityManagerImpl(this, this.deploymentDataManager);
        }
        if (this.formDefinitionEntityManager == null) {
            this.formDefinitionEntityManager = new FormDefinitionEntityManagerImpl(this, this.formDefinitionDataManager);
        }
        if (this.resourceEntityManager == null) {
            this.resourceEntityManager = new ResourceEntityManagerImpl(this, this.resourceDataManager);
        }
        if (this.formInstanceEntityManager == null) {
            this.formInstanceEntityManager = new FormInstanceEntityManagerImpl(this, this.formInstanceDataManager);
        }
        if (this.tableDataManager == null) {
            this.tableDataManager = new TableDataManagerImpl(this);
        }
    }

    public void initDbSchema() {
        try {
            JdbcConnection connection = new JdbcConnection(this.dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)this.databaseSchema)) {
                database.setDefaultSchemaName(this.databaseSchema);
                database.setLiquibaseSchemaName(this.databaseSchema);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.databaseCatalog)) {
                database.setDefaultCatalogName(this.databaseCatalog);
                database.setLiquibaseCatalogName(this.databaseCatalog);
            }
            Liquibase liquibase = new Liquibase("org/flowable/form/db/liquibase/flowable-form-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            if ("drop-create".equals(this.databaseSchemaUpdate)) {
                logger.debug("Dropping and creating schema FORM");
                liquibase.dropAll();
                liquibase.update("form");
            } else if ("true".equals(this.databaseSchemaUpdate)) {
                logger.debug("Updating schema FORM");
                liquibase.update("form");
            } else if ("false".equals(this.databaseSchemaUpdate)) {
                logger.debug("Validating schema FORM");
                liquibase.validate();
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error initialising form data schema", (Throwable)e);
        }
    }

    public void initSessionFactories() {
        if (this.sessionFactories == null) {
            this.sessionFactories = new HashMap();
            if (this.usingRelationalDatabase) {
                this.initDbSqlSessionFactory();
            }
        }
        if (this.customSessionFactories != null) {
            for (SessionFactory sessionFactory : this.customSessionFactories) {
                this.addSessionFactory(sessionFactory);
            }
        }
    }

    public void initDbSqlSessionFactory() {
        if (this.dbSqlSessionFactory == null) {
            this.dbSqlSessionFactory = this.createDbSqlSessionFactory();
        }
        this.dbSqlSessionFactory.setDatabaseType(this.databaseType);
        this.dbSqlSessionFactory.setSqlSessionFactory(this.sqlSessionFactory);
        this.dbSqlSessionFactory.setIdGenerator(this.idGenerator);
        this.dbSqlSessionFactory.setDatabaseTablePrefix(this.databaseTablePrefix);
        this.dbSqlSessionFactory.setTablePrefixIsSchema(this.tablePrefixIsSchema);
        this.dbSqlSessionFactory.setDatabaseCatalog(this.databaseCatalog);
        this.dbSqlSessionFactory.setDatabaseSchema(this.databaseSchema);
        this.addSessionFactory((SessionFactory)this.dbSqlSessionFactory);
    }

    public DbSqlSessionFactory createDbSqlSessionFactory() {
        return new DbSqlSessionFactory();
    }

    public void initCommandExecutors() {
        this.initDefaultCommandConfig();
        this.initSchemaCommandConfig();
        this.initCommandInvoker();
        this.initCommandInterceptors();
        this.initCommandExecutor();
    }

    public void initCommandInvoker() {
        if (this.commandInvoker == null) {
            this.commandInvoker = new CommandInvoker();
        }
    }

    public void initCommandInterceptors() {
        if (this.commandInterceptors == null) {
            this.commandInterceptors = new ArrayList<CommandInterceptor>();
            if (this.customPreCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPreCommandInterceptors);
            }
            this.commandInterceptors.addAll(this.getDefaultCommandInterceptors());
            if (this.customPostCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPostCommandInterceptors);
            }
            this.commandInterceptors.add(this.commandInvoker);
        }
    }

    public Collection<? extends CommandInterceptor> getDefaultCommandInterceptors() {
        ArrayList<CommandInterceptor> interceptors = new ArrayList<CommandInterceptor>();
        interceptors.add(new LogInterceptor());
        interceptors.add(new CommandContextInterceptor(this.commandContextFactory, this));
        CommandInterceptor transactionInterceptor = this.createTransactionInterceptor();
        if (transactionInterceptor != null) {
            interceptors.add(transactionInterceptor);
        }
        return interceptors;
    }

    public void initCommandExecutor() {
        if (this.commandExecutor == null) {
            CommandInterceptor first = this.initInterceptorChain(this.commandInterceptors);
            this.commandExecutor = new CommandExecutorImpl(this.getDefaultCommandConfig(), first);
        }
    }

    public CommandInterceptor initInterceptorChain(List<CommandInterceptor> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new FlowableException("invalid command interceptor chain configuration: " + chain);
        }
        for (int i = 0; i < chain.size() - 1; ++i) {
            chain.get(i).setNext(chain.get(i + 1));
        }
        return chain.get(0);
    }

    public CommandInterceptor createTransactionInterceptor() {
        if (this.transactionContextFactory != null) {
            return new TransactionContextInterceptor(this.transactionContextFactory);
        }
        return null;
    }

    protected void initDeployers() {
        if (this.formParseFactory == null) {
            this.formParseFactory = new FormDefinitionParseFactory();
        }
        if (this.formDeployer == null) {
            this.deployers = new ArrayList<Deployer>();
            if (this.customPreDeployers != null) {
                this.deployers.addAll(this.customPreDeployers);
            }
            this.deployers.addAll(this.getDefaultDeployers());
            if (this.customPostDeployers != null) {
                this.deployers.addAll(this.customPostDeployers);
            }
        }
        if (this.formDefinitionCache == null) {
            this.formDefinitionCache = this.formDefinitionCacheLimit <= 0 ? new DefaultDeploymentCache<FormDefinitionCacheEntry>() : new DefaultDeploymentCache<FormDefinitionCacheEntry>(this.formDefinitionCacheLimit);
        }
        this.deploymentManager = new DeploymentManager(this.formDefinitionCache, this);
        this.deploymentManager.setDeployers(this.deployers);
        this.deploymentManager.setDeploymentEntityManager(this.deploymentEntityManager);
        this.deploymentManager.setFormDefinitionEntityManager(this.formDefinitionEntityManager);
    }

    public Collection<? extends Deployer> getDefaultDeployers() {
        ArrayList<FormDefinitionDeployer> defaultDeployers = new ArrayList<FormDefinitionDeployer>();
        if (this.formDeployer == null) {
            this.formDeployer = new FormDefinitionDeployer();
        }
        this.initDmnDeployerDependencies();
        this.formDeployer.setIdGenerator(this.idGenerator);
        this.formDeployer.setParsedDeploymentBuilderFactory(this.parsedDeploymentBuilderFactory);
        this.formDeployer.setFormDeploymentHelper(this.formDeploymentHelper);
        this.formDeployer.setCachingAndArtifactsManager(this.cachingAndArtifactsManager);
        defaultDeployers.add(this.formDeployer);
        return defaultDeployers;
    }

    public void initDmnDeployerDependencies() {
        if (this.parsedDeploymentBuilderFactory == null) {
            this.parsedDeploymentBuilderFactory = new ParsedDeploymentBuilderFactory();
        }
        if (this.parsedDeploymentBuilderFactory.getFormParseFactory() == null) {
            this.parsedDeploymentBuilderFactory.setFormParseFactory(this.formParseFactory);
        }
        if (this.formDeploymentHelper == null) {
            this.formDeploymentHelper = new FormDefinitionDeploymentHelper();
        }
        if (this.cachingAndArtifactsManager == null) {
            this.cachingAndArtifactsManager = new CachingAndArtifactsManager();
        }
    }

    public void initCommandContextFactory() {
        if (this.commandContextFactory == null) {
            this.commandContextFactory = new CommandContextFactory();
        }
        this.commandContextFactory.setDmnEngineConfiguration(this);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new StandaloneMybatisTransactionContextFactory();
        }
    }

    public InputStream getMyBatisXmlConfigurationStream() {
        return this.getResourceAsStream(DEFAULT_MYBATIS_MAPPING_FILE);
    }

    public String getEngineName() {
        return this.formEngineName;
    }

    public FormEngineConfiguration setEngineName(String formEngineName) {
        this.formEngineName = formEngineName;
        return this;
    }

    public FormEngineConfiguration setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public FormEngineConfiguration setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public FormEngineConfiguration setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public FormEngineConfiguration setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public FormEngineConfiguration setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
        return this;
    }

    public FormEngineConfiguration setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
        return this;
    }

    public FormEngineConfiguration setJdbcMaxActiveConnections(int jdbcMaxActiveConnections) {
        this.jdbcMaxActiveConnections = jdbcMaxActiveConnections;
        return this;
    }

    public FormEngineConfiguration setJdbcMaxIdleConnections(int jdbcMaxIdleConnections) {
        this.jdbcMaxIdleConnections = jdbcMaxIdleConnections;
        return this;
    }

    public FormEngineConfiguration setJdbcMaxCheckoutTime(int jdbcMaxCheckoutTime) {
        this.jdbcMaxCheckoutTime = jdbcMaxCheckoutTime;
        return this;
    }

    public FormEngineConfiguration setJdbcMaxWaitTime(int jdbcMaxWaitTime) {
        this.jdbcMaxWaitTime = jdbcMaxWaitTime;
        return this;
    }

    public FormEngineConfiguration setJdbcPingEnabled(boolean jdbcPingEnabled) {
        this.jdbcPingEnabled = jdbcPingEnabled;
        return this;
    }

    public FormEngineConfiguration setJdbcPingConnectionNotUsedFor(int jdbcPingConnectionNotUsedFor) {
        this.jdbcPingConnectionNotUsedFor = jdbcPingConnectionNotUsedFor;
        return this;
    }

    public FormEngineConfiguration setJdbcDefaultTransactionIsolationLevel(int jdbcDefaultTransactionIsolationLevel) {
        this.jdbcDefaultTransactionIsolationLevel = jdbcDefaultTransactionIsolationLevel;
        return this;
    }

    public FormEngineConfiguration setJdbcPingQuery(String jdbcPingQuery) {
        this.jdbcPingQuery = jdbcPingQuery;
        return this;
    }

    public FormEngineConfiguration setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
        return this;
    }

    public FormEngineConfiguration setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
        return this;
    }

    public FormEngineConfiguration setBeans(Map<Object, Object> beans) {
        this.beans = beans;
        return this;
    }

    public FormEngineConfiguration setDefaultCommandConfig(CommandConfig defaultCommandConfig) {
        this.defaultCommandConfig = defaultCommandConfig;
        return this;
    }

    public CommandInterceptor getCommandInvoker() {
        return this.commandInvoker;
    }

    public FormEngineConfiguration setCommandInvoker(CommandInterceptor commandInvoker) {
        this.commandInvoker = commandInvoker;
        return this;
    }

    public List<CommandInterceptor> getCustomPreCommandInterceptors() {
        return this.customPreCommandInterceptors;
    }

    public FormEngineConfiguration setCustomPreCommandInterceptors(List<CommandInterceptor> customPreCommandInterceptors) {
        this.customPreCommandInterceptors = customPreCommandInterceptors;
        return this;
    }

    public List<CommandInterceptor> getCustomPostCommandInterceptors() {
        return this.customPostCommandInterceptors;
    }

    public FormEngineConfiguration setCustomPostCommandInterceptors(List<CommandInterceptor> customPostCommandInterceptors) {
        this.customPostCommandInterceptors = customPostCommandInterceptors;
        return this;
    }

    public List<CommandInterceptor> getCommandInterceptors() {
        return this.commandInterceptors;
    }

    public FormEngineConfiguration setCommandInterceptors(List<CommandInterceptor> commandInterceptors) {
        this.commandInterceptors = commandInterceptors;
        return this;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public FormEngineConfiguration setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public FormManagementService getFormManagementService() {
        return this.formManagementService;
    }

    public FormEngineConfiguration setFormManagementService(FormManagementService formManagementService) {
        this.formManagementService = formManagementService;
        return this;
    }

    public FormRepositoryService getFormRepositoryService() {
        return this.formRepositoryService;
    }

    public FormEngineConfiguration setFormRepositoryService(FormRepositoryService formRepositoryService) {
        this.formRepositoryService = formRepositoryService;
        return this;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public FormEngineConfiguration setFormService(FormService formService) {
        this.formService = formService;
        return this;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public FormEngineConfiguration getFormEngineConfiguration() {
        return this;
    }

    public FormDefinitionDeployer getFormDeployer() {
        return this.formDeployer;
    }

    public FormEngineConfiguration setFormDeployer(FormDefinitionDeployer formDeployer) {
        this.formDeployer = formDeployer;
        return this;
    }

    public FormDefinitionParseFactory getFormParseFactory() {
        return this.formParseFactory;
    }

    public FormEngineConfiguration setFormParseFactory(FormDefinitionParseFactory formParseFactory) {
        this.formParseFactory = formParseFactory;
        return this;
    }

    public int getFormCacheLimit() {
        return this.formDefinitionCacheLimit;
    }

    public FormEngineConfiguration setFormDefinitionCacheLimit(int formDefinitionCacheLimit) {
        this.formDefinitionCacheLimit = formDefinitionCacheLimit;
        return this;
    }

    public DeploymentCache<FormDefinitionCacheEntry> getFormDefinitionCache() {
        return this.formDefinitionCache;
    }

    public FormEngineConfiguration setFormDefinitionCache(DeploymentCache<FormDefinitionCacheEntry> formDefinitionCache) {
        this.formDefinitionCache = formDefinitionCache;
        return this;
    }

    public FormDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public FormEngineConfiguration setDeploymentDataManager(FormDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
        return this;
    }

    public FormDefinitionDataManager getFormDefinitionDataManager() {
        return this.formDefinitionDataManager;
    }

    public FormEngineConfiguration setFormDefinitionDataManager(FormDefinitionDataManager formDefinitionDataManager) {
        this.formDefinitionDataManager = formDefinitionDataManager;
        return this;
    }

    public ResourceDataManager getResourceDataManager() {
        return this.resourceDataManager;
    }

    public FormEngineConfiguration setResourceDataManager(ResourceDataManager resourceDataManager) {
        this.resourceDataManager = resourceDataManager;
        return this;
    }

    public FormInstanceDataManager getFormInstanceDataManager() {
        return this.formInstanceDataManager;
    }

    public FormEngineConfiguration setFormInstanceDataManager(FormInstanceDataManager formInstanceDataManager) {
        this.formInstanceDataManager = formInstanceDataManager;
        return this;
    }

    public FormDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public FormEngineConfiguration setDeploymentEntityManager(FormDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
        return this;
    }

    public FormDefinitionEntityManager getFormDefinitionEntityManager() {
        return this.formDefinitionEntityManager;
    }

    public FormEngineConfiguration setFormDefinitionEntityManager(FormDefinitionEntityManager formDefinitionEntityManager) {
        this.formDefinitionEntityManager = formDefinitionEntityManager;
        return this;
    }

    public ResourceEntityManager getResourceEntityManager() {
        return this.resourceEntityManager;
    }

    public FormEngineConfiguration setResourceEntityManager(ResourceEntityManager resourceEntityManager) {
        this.resourceEntityManager = resourceEntityManager;
        return this;
    }

    public FormInstanceEntityManager getFormInstanceEntityManager() {
        return this.formInstanceEntityManager;
    }

    public FormEngineConfiguration setFormInstanceEntityManager(FormInstanceEntityManager formInstanceEntityManager) {
        this.formInstanceEntityManager = formInstanceEntityManager;
        return this;
    }

    public TableDataManager getTableDataManager() {
        return this.tableDataManager;
    }

    public FormEngineConfiguration setTableDataManager(TableDataManager tableDataManager) {
        this.tableDataManager = tableDataManager;
        return this;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public FormEngineConfiguration setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
        return this;
    }

    public FormEngineConfiguration setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public FormEngineConfiguration setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
        return this;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public FormEngineConfiguration setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    public FormJsonConverter getFormJsonConverter() {
        return this.formJsonConverter;
    }

    public FormEngineConfiguration setFormJsonConverter(FormJsonConverter formJsonConverter) {
        this.formJsonConverter = formJsonConverter;
        return this;
    }

    public FormEngineConfiguration setCustomMybatisMappers(Set<Class<?>> customMybatisMappers) {
        this.customMybatisMappers = customMybatisMappers;
        return this;
    }

    public FormEngineConfiguration setCustomMybatisXMLMappers(Set<String> customMybatisXMLMappers) {
        this.customMybatisXMLMappers = customMybatisXMLMappers;
        return this;
    }

    public FormEngineConfiguration setCustomSessionFactories(List<SessionFactory> customSessionFactories) {
        this.customSessionFactories = customSessionFactories;
        return this;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public FormEngineConfiguration setDbSqlSessionFactory(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        return this;
    }

    public FormEngineConfiguration setUsingRelationalDatabase(boolean usingRelationalDatabase) {
        this.usingRelationalDatabase = usingRelationalDatabase;
        return this;
    }

    public FormEngineConfiguration setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
        return this;
    }

    public FormEngineConfiguration setDatabaseCatalog(String databaseCatalog) {
        this.databaseCatalog = databaseCatalog;
        return this;
    }

    public FormEngineConfiguration setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    public FormEngineConfiguration setTablePrefixIsSchema(boolean tablePrefixIsSchema) {
        this.tablePrefixIsSchema = tablePrefixIsSchema;
        return this;
    }

    public FormEngineConfiguration setSessionFactories(Map<Class<?>, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
        return this;
    }

    public TransactionContextFactory<TransactionListener, CommandContext> getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public FormEngineConfiguration setTransactionContextFactory(TransactionContextFactory<TransactionListener, CommandContext> transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
        return this;
    }

    public FormEngineConfiguration setDatabaseSchemaUpdate(String databaseSchemaUpdate) {
        this.databaseSchemaUpdate = databaseSchemaUpdate;
        return this;
    }

    public FormEngineConfiguration setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public FormEngineConfiguration setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }
}

