/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.editor.form.converter.FormJsonConverter;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.form.api.FormInstance;
import org.flowable.form.api.FormInstanceQuery;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.FormExpression;
import org.flowable.form.engine.impl.interceptor.Command;
import org.flowable.form.engine.impl.interceptor.CommandContext;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntity;
import org.flowable.form.model.ExpressionFormField;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormInstanceModel;
import org.flowable.form.model.FormModel;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFormInstanceModelCmd
implements Command<FormInstanceModel>,
Serializable {
    private static Logger logger = LoggerFactory.getLogger(GetFormInstanceModelCmd.class);
    private static final long serialVersionUID = 1L;
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("d-M-yyyy");
    protected String formInstanceId;
    protected String formDefinitionKey;
    protected String parentDeploymentId;
    protected String formDefinitionId;
    protected String taskId;
    protected String processInstanceId;
    protected String tenantId;
    protected Map<String, Object> variables;

    public GetFormInstanceModelCmd(String formInstanceId, Map<String, Object> variables) {
        this.initializeValues(null, null, null, null, null, null, variables);
        this.formInstanceId = formInstanceId;
    }

    public GetFormInstanceModelCmd(String formDefinitionKey, String formDefinitionId, String taskId, String processInstanceId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, null, formDefinitionId, null, taskId, processInstanceId, variables);
    }

    public GetFormInstanceModelCmd(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String taskId, String processInstanceId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, parentDeploymentId, formDefinitionId, null, taskId, processInstanceId, variables);
    }

    public GetFormInstanceModelCmd(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String taskId, String processInstanceId, String tenantId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, parentDeploymentId, formDefinitionId, tenantId, taskId, processInstanceId, variables);
    }

    @Override
    public FormInstanceModel execute(CommandContext commandContext) {
        if (this.formInstanceId == null && this.taskId == null && this.processInstanceId == null) {
            throw new FlowableException("A processtask id or process instance id should be provided");
        }
        FormDefinitionCacheEntry formDefinitionCacheEntry = this.resolveFormDefinition(commandContext);
        FormInstance formInstance = this.resolveFormInstance(commandContext);
        FormInstanceModel formInstanceModel = this.resolveFormInstanceModel(formDefinitionCacheEntry, formInstance, commandContext);
        this.fillFormFieldValues(formInstance, formInstanceModel, commandContext);
        return formInstanceModel;
    }

    protected void initializeValues(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String tenantId, String taskId, String processInstanceId, Map<String, Object> variables) {
        this.formDefinitionKey = formDefinitionKey;
        this.parentDeploymentId = parentDeploymentId;
        this.formDefinitionId = formDefinitionId;
        this.tenantId = tenantId;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.variables = variables != null ? variables : new HashMap<String, Object>();
    }

    protected void fillFormFieldValues(FormInstance formInstance, FormInstanceModel formInstanceModel, CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = commandContext.getFormEngineConfiguration();
        List allFields = formInstanceModel.listAllFields();
        if (allFields != null) {
            HashMap<String, JsonNode> formInstanceFieldMap = new HashMap<String, JsonNode>();
            if (formInstance != null) {
                this.fillFormInstanceValues(formInstanceModel, formInstance, formInstanceFieldMap, formEngineConfiguration.getObjectMapper());
                this.fillVariablesWithFormValues(formInstanceFieldMap, allFields);
            }
            for (FormField field : allFields) {
                if (field instanceof ExpressionFormField) {
                    ExpressionFormField expressionField = (ExpressionFormField)field;
                    FormExpression formExpression = formEngineConfiguration.getExpressionManager().createExpression(expressionField.getExpression());
                    try {
                        field.setValue(formExpression.getValue(this.variables));
                    }
                    catch (Exception e) {
                        logger.error("Error getting value for expression {} {}", (Object)expressionField.getExpression(), (Object)e.getMessage());
                    }
                } else if ("upload".equals(field.getType())) {
                    String uploadValue;
                    if (this.variables.containsKey(field.getId()) && (uploadValue = (String)this.variables.get(field.getId())) != null) {
                        ArrayList contentIds = new ArrayList();
                        Collections.addAll(contentIds, uploadValue.split(","));
                        field.setValue(contentIds);
                    }
                } else {
                    Object variableValue = this.variables.get(field.getId());
                    if (variableValue != null) {
                        if (variableValue instanceof LocalDate) {
                            field.setValue((Object)((LocalDate)variableValue).toString("d-M-yyyy"));
                        } else if (variableValue instanceof Date) {
                            field.setValue((Object)DATE_FORMAT.format((Date)variableValue));
                        } else {
                            field.setValue(variableValue);
                        }
                    }
                }
                field.setReadOnly(true);
            }
        }
    }

    protected FormDefinitionCacheEntry resolveFormDefinition(CommandContext commandContext) {
        DeploymentManager deploymentManager = commandContext.getFormEngineConfiguration().getDeploymentManager();
        FormDefinitionEntity formDefinitionEntity = null;
        if (this.formInstanceId != null) {
            FormInstanceEntity formInstanceEntity = (FormInstanceEntity)commandContext.getFormEngineConfiguration().getFormInstanceDataManager().findById(this.formInstanceId);
            if (formInstanceEntity == null) {
                throw new FlowableObjectNotFoundException("No form instance found for id = '" + this.formInstanceId + "'", FormInstanceEntity.class);
            }
            formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(formInstanceEntity.getFormDefinitionId());
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionId != null) {
            formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(this.formDefinitionId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId == null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKey(this.formDefinitionKey);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId == null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyAndParentDeploymentId(this.formDefinitionKey, this.parentDeploymentId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKeyParentDeploymentIdAndTenantId(this.formDefinitionKey, this.parentDeploymentId, this.tenantId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else {
            throw new FlowableObjectNotFoundException("formDefinitionKey and formDefinitionId are null");
        }
        FormDefinitionCacheEntry formCacheEntry = deploymentManager.resolveFormDefinition(formDefinitionEntity);
        return formCacheEntry;
    }

    protected FormInstance resolveFormInstance(CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = commandContext.getFormEngineConfiguration();
        FormInstanceQuery formInstanceQuery = formEngineConfiguration.getFormService().createFormInstanceQuery().formDefinitionId(this.formDefinitionId);
        if (this.formInstanceId != null) {
            formInstanceQuery.id(this.formInstanceId);
        } else if (this.taskId != null) {
            formInstanceQuery.taskId(this.taskId);
        } else if (this.processInstanceId != null) {
            formInstanceQuery.processInstanceId(this.processInstanceId);
        } else {
            return null;
        }
        List formInstances = ((FormInstanceQuery)formInstanceQuery.orderBySubmittedDate().asc()).list();
        if (!formInstances.isEmpty()) {
            return (FormInstance)formInstances.get(0);
        }
        return null;
    }

    protected void fillFormInstanceValues(FormInstanceModel formInstanceModel, FormInstance formInstance, Map<String, JsonNode> formInstanceFieldMap, ObjectMapper objectMapper) {
        try {
            JsonNode outcomeNode;
            JsonNode submittedNode = objectMapper.readTree(formInstance.getFormValueBytes());
            if (submittedNode == null) {
                return;
            }
            if (submittedNode.get("values") != null) {
                JsonNode valuesNode = submittedNode.get("values");
                Iterator fieldIdIterator = valuesNode.fieldNames();
                while (fieldIdIterator.hasNext()) {
                    String fieldId = (String)fieldIdIterator.next();
                    JsonNode valueNode = valuesNode.get(fieldId);
                    formInstanceFieldMap.put(fieldId, valueNode);
                }
            }
            if (submittedNode.get("flowable_form_outcome") != null && !(outcomeNode = submittedNode.get("flowable_form_outcome")).isNull() && StringUtils.isNotEmpty((CharSequence)outcomeNode.asText())) {
                formInstanceModel.setSelectedOutcome(outcomeNode.asText());
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error parsing form instance " + formInstance.getId(), (Throwable)e);
        }
    }

    public void fillVariablesWithFormValues(Map<String, JsonNode> submittedFormFieldMap, List<FormField> allFields) {
        for (FormField field : allFields) {
            JsonNode fieldValueNode = submittedFormFieldMap.get(field.getId());
            if (fieldValueNode == null || fieldValueNode.isNull()) continue;
            String fieldType = field.getType();
            String fieldValue = fieldValueNode.asText();
            if ("date".equals(fieldType)) {
                try {
                    if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                    LocalDate dateValue = LocalDate.parse((String)fieldValue);
                    this.variables.put(field.getId(), dateValue.toString("d-M-yyyy"));
                }
                catch (Exception e) {
                    logger.error("Error parsing form date value for process instance {} and task {} with value {}", new Object[]{this.processInstanceId, this.taskId, fieldValue, e});
                }
                continue;
            }
            this.variables.put(field.getId(), fieldValue);
        }
    }

    protected FormInstanceModel resolveFormInstanceModel(FormDefinitionCacheEntry formCacheEntry, FormInstance formInstance, CommandContext commandContext) {
        FormDefinitionEntity formDefinitionEntity = formCacheEntry.getFormDefinitionEntity();
        FormJsonConverter formJsonConverter = commandContext.getFormEngineConfiguration().getFormJsonConverter();
        FormModel formModel = formJsonConverter.convertToFormModel(formCacheEntry.getFormDefinitionJson(), formDefinitionEntity.getId(), formDefinitionEntity.getVersion());
        FormInstanceModel formInstanceModel = new FormInstanceModel(formModel);
        formInstanceModel.setId(formDefinitionEntity.getId());
        formInstanceModel.setName(formDefinitionEntity.getName());
        formInstanceModel.setKey(formDefinitionEntity.getKey());
        formInstanceModel.setTenantId(formDefinitionEntity.getTenantId());
        if (formInstance != null) {
            formInstanceModel.setFormInstanceId(formInstance.getId());
            formInstanceModel.setTaskId(formInstance.getTaskId());
            formInstanceModel.setProcessInstanceId(formInstance.getProcessInstanceId());
            formInstanceModel.setProcessDefinitionId(formInstance.getProcessDefinitionId());
            formInstanceModel.setSubmittedBy(formInstance.getSubmittedBy());
            formInstanceModel.setSubmittedDate(formInstance.getSubmittedDate());
        }
        return formInstanceModel;
    }
}

