/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.deployer;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.form.engine.impl.context.Context;
import org.flowable.form.engine.impl.deployer.ParsedDeployment;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;

public class FormDefinitionDeploymentHelper {
    public void verifyFormsDoNotShareKeys(Collection<FormDefinitionEntity> forms) {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (FormDefinitionEntity form : forms) {
            if (keySet.contains(form.getKey())) {
                throw new FlowableException("The deployment contains forms with the same key, this is not allowed");
            }
            keySet.add(form.getKey());
        }
    }

    public void copyDeploymentValuesToForms(FormDeploymentEntity deployment, List<FormDefinitionEntity> formDefinitions) {
        String tenantId = deployment.getTenantId();
        String deploymentId = deployment.getId();
        for (FormDefinitionEntity formDefinition : formDefinitions) {
            if (tenantId != null) {
                formDefinition.setTenantId(tenantId);
            }
            formDefinition.setDeploymentId(deploymentId);
        }
    }

    public void setResourceNamesOnFormDefinitions(ParsedDeployment parsedDeployment) {
        for (FormDefinitionEntity formDefinition : parsedDeployment.getAllFormDefinitions()) {
            String resourceName = parsedDeployment.getResourceForFormDefinition(formDefinition).getName();
            formDefinition.setResourceName(resourceName);
        }
    }

    public FormDefinitionEntity getMostRecentVersionOfForm(FormDefinitionEntity formDefinition) {
        String key = formDefinition.getKey();
        String tenantId = formDefinition.getTenantId();
        FormDefinitionEntityManager formDefinitionEntityManager = Context.getCommandContext().getFormEngineConfiguration().getFormDefinitionEntityManager();
        FormDefinitionEntity existingDefinition = null;
        existingDefinition = tenantId != null && !tenantId.equals("") ? formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(key, tenantId) : formDefinitionEntityManager.findLatestFormDefinitionByKey(key);
        return existingDefinition;
    }

    public FormDefinitionEntity getPersistedInstanceOfFormDefinition(FormDefinitionEntity formDefinition) {
        String deploymentId = formDefinition.getDeploymentId();
        if (StringUtils.isEmpty((CharSequence)formDefinition.getDeploymentId())) {
            throw new FlowableIllegalArgumentException("Provided form definition must have a deployment id.");
        }
        FormDefinitionEntityManager formDefinitionEntityManager = Context.getCommandContext().getFormEngineConfiguration().getFormDefinitionEntityManager();
        FormDefinitionEntity persistedFormDefinition = null;
        persistedFormDefinition = formDefinition.getTenantId() == null || "".equals(formDefinition.getTenantId()) ? formDefinitionEntityManager.findFormDefinitionByDeploymentAndKey(deploymentId, formDefinition.getKey()) : formDefinitionEntityManager.findFormDefinitionByDeploymentAndKeyAndTenantId(deploymentId, formDefinition.getKey(), formDefinition.getTenantId());
        return persistedFormDefinition;
    }
}

