/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.persistence.entity;

import java.io.Serializable;
import org.flowable.form.engine.impl.context.Context;
import org.flowable.form.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.form.engine.impl.persistence.entity.ResourceEntityManager;

public class ResourceRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private ResourceEntity entity;
    protected boolean deleted;

    public ResourceRef() {
    }

    public ResourceRef(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        this.ensureInitialized();
        return this.entity != null ? this.entity.getBytes() : null;
    }

    public void setValue(String name, byte[] bytes) {
        this.name = name;
        this.setBytes(bytes);
    }

    private void setBytes(byte[] bytes) {
        ResourceEntityManager resourceEntityManager = Context.getCommandContext().getResourceEntityManager();
        if (this.id == null) {
            if (bytes != null) {
                this.entity = (ResourceEntity)resourceEntityManager.create();
                this.entity.setName(this.name);
                this.entity.setBytes(bytes);
                resourceEntityManager.insert(this.entity);
                this.id = this.entity.getId();
            }
        } else {
            this.ensureInitialized();
            this.entity.setBytes(bytes);
            resourceEntityManager.update(this.entity);
        }
    }

    public ResourceEntity getEntity() {
        this.ensureInitialized();
        return this.entity;
    }

    public void delete() {
        if (!this.deleted && this.id != null) {
            if (this.entity != null) {
                Context.getCommandContext().getResourceEntityManager().delete(this.entity);
            } else {
                Context.getCommandContext().getResourceEntityManager().delete(this.id);
            }
            this.entity = null;
            this.id = null;
            this.deleted = true;
        }
    }

    private void ensureInitialized() {
        if (this.id != null && this.entity == null) {
            this.entity = (ResourceEntity)Context.getCommandContext().getResourceEntityManager().findById(this.id);
            this.name = this.entity.getName();
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String toString() {
        return "ResourceRef[id=" + this.id + ", name=" + this.name + ", entity=" + this.entity + (this.deleted ? ", deleted]" : "]");
    }
}

