/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl;

import java.util.List;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.NativeGroupQuery;
import org.flowable.idm.api.NativeTokenQuery;
import org.flowable.idm.api.NativeUserQuery;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.PrivilegeMapping;
import org.flowable.idm.api.PrivilegeQuery;
import org.flowable.idm.api.Token;
import org.flowable.idm.api.TokenQuery;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.engine.impl.NativeGroupQueryImpl;
import org.flowable.idm.engine.impl.NativeTokenQueryImpl;
import org.flowable.idm.engine.impl.NativeUserQueryImpl;
import org.flowable.idm.engine.impl.ServiceImpl;
import org.flowable.idm.engine.impl.cmd.AddPrivilegeMappingCmd;
import org.flowable.idm.engine.impl.cmd.CheckPassword;
import org.flowable.idm.engine.impl.cmd.CreateGroupCmd;
import org.flowable.idm.engine.impl.cmd.CreateGroupQueryCmd;
import org.flowable.idm.engine.impl.cmd.CreateMembershipCmd;
import org.flowable.idm.engine.impl.cmd.CreatePrivilegeCmd;
import org.flowable.idm.engine.impl.cmd.CreatePrivilegeQueryCmd;
import org.flowable.idm.engine.impl.cmd.CreateTokenCmd;
import org.flowable.idm.engine.impl.cmd.CreateTokenQueryCmd;
import org.flowable.idm.engine.impl.cmd.CreateUserCmd;
import org.flowable.idm.engine.impl.cmd.CreateUserQueryCmd;
import org.flowable.idm.engine.impl.cmd.DeleteGroupCmd;
import org.flowable.idm.engine.impl.cmd.DeleteMembershipCmd;
import org.flowable.idm.engine.impl.cmd.DeletePrivilegeCmd;
import org.flowable.idm.engine.impl.cmd.DeletePrivilegeMappingCmd;
import org.flowable.idm.engine.impl.cmd.DeleteTokenCmd;
import org.flowable.idm.engine.impl.cmd.DeleteUserCmd;
import org.flowable.idm.engine.impl.cmd.DeleteUserInfoCmd;
import org.flowable.idm.engine.impl.cmd.GetGroupsWithPrivilegeCmd;
import org.flowable.idm.engine.impl.cmd.GetPrivilegeMappingsByPrivilegeIdCmd;
import org.flowable.idm.engine.impl.cmd.GetUserInfoCmd;
import org.flowable.idm.engine.impl.cmd.GetUserInfoKeysCmd;
import org.flowable.idm.engine.impl.cmd.GetUserPictureCmd;
import org.flowable.idm.engine.impl.cmd.GetUsersWithPrivilegeCmd;
import org.flowable.idm.engine.impl.cmd.SaveGroupCmd;
import org.flowable.idm.engine.impl.cmd.SaveTokenCmd;
import org.flowable.idm.engine.impl.cmd.SaveUserCmd;
import org.flowable.idm.engine.impl.cmd.SetUserInfoCmd;
import org.flowable.idm.engine.impl.cmd.SetUserPictureCmd;
import org.flowable.idm.engine.impl.cmd.UpdateUserPasswordCmd;

public class IdmIdentityServiceImpl
extends ServiceImpl
implements IdmIdentityService {
    public Group newGroup(String groupId) {
        return this.commandExecutor.execute(new CreateGroupCmd(groupId));
    }

    public User newUser(String userId) {
        return this.commandExecutor.execute(new CreateUserCmd(userId));
    }

    public void saveGroup(Group group) {
        this.commandExecutor.execute(new SaveGroupCmd(group));
    }

    public void saveUser(User user) {
        this.commandExecutor.execute(new SaveUserCmd(user));
    }

    public void updateUserPassword(User user) {
        this.commandExecutor.execute(new UpdateUserPasswordCmd(user));
    }

    public UserQuery createUserQuery() {
        return this.commandExecutor.execute(new CreateUserQueryCmd());
    }

    public NativeUserQuery createNativeUserQuery() {
        return new NativeUserQueryImpl(this.commandExecutor);
    }

    public GroupQuery createGroupQuery() {
        return this.commandExecutor.execute(new CreateGroupQueryCmd());
    }

    public NativeGroupQuery createNativeGroupQuery() {
        return new NativeGroupQueryImpl(this.commandExecutor);
    }

    public void createMembership(String userId, String groupId) {
        this.commandExecutor.execute(new CreateMembershipCmd(userId, groupId));
    }

    public void deleteGroup(String groupId) {
        this.commandExecutor.execute(new DeleteGroupCmd(groupId));
    }

    public void deleteMembership(String userId, String groupId) {
        this.commandExecutor.execute(new DeleteMembershipCmd(userId, groupId));
    }

    public boolean checkPassword(String userId, String password) {
        return this.commandExecutor.execute(new CheckPassword(userId, password));
    }

    public void deleteUser(String userId) {
        this.commandExecutor.execute(new DeleteUserCmd(userId));
    }

    public Token newToken(String tokenId) {
        return this.commandExecutor.execute(new CreateTokenCmd(tokenId));
    }

    public void saveToken(Token token) {
        this.commandExecutor.execute(new SaveTokenCmd(token));
    }

    public void deleteToken(String tokenId) {
        this.commandExecutor.execute(new DeleteTokenCmd(tokenId));
    }

    public TokenQuery createTokenQuery() {
        return this.commandExecutor.execute(new CreateTokenQueryCmd());
    }

    public NativeTokenQuery createNativeTokenQuery() {
        return new NativeTokenQueryImpl(this.commandExecutor);
    }

    public void setUserPicture(String userId, Picture picture) {
        this.commandExecutor.execute(new SetUserPictureCmd(userId, picture));
    }

    public Picture getUserPicture(String userId) {
        return this.commandExecutor.execute(new GetUserPictureCmd(userId));
    }

    public String getUserInfo(String userId, String key) {
        return this.commandExecutor.execute(new GetUserInfoCmd(userId, key));
    }

    public List<String> getUserInfoKeys(String userId) {
        return this.commandExecutor.execute(new GetUserInfoKeysCmd(userId, "userinfo"));
    }

    public void setUserInfo(String userId, String key, String value) {
        this.commandExecutor.execute(new SetUserInfoCmd(userId, key, value));
    }

    public void deleteUserInfo(String userId, String key) {
        this.commandExecutor.execute(new DeleteUserInfoCmd(userId, key));
    }

    public Privilege createPrivilege(String name) {
        return this.commandExecutor.execute(new CreatePrivilegeCmd(name));
    }

    public void addUserPrivilegeMapping(String privilegeId, String userId) {
        this.commandExecutor.execute(new AddPrivilegeMappingCmd(privilegeId, userId, null));
    }

    public void deleteUserPrivilegeMapping(String privilegeId, String userId) {
        this.commandExecutor.execute(new DeletePrivilegeMappingCmd(privilegeId, userId, null));
    }

    public void addGroupPrivilegeMapping(String privilegeId, String groupId) {
        this.commandExecutor.execute(new AddPrivilegeMappingCmd(privilegeId, null, groupId));
    }

    public void deleteGroupPrivilegeMapping(String privilegeId, String groupId) {
        this.commandExecutor.execute(new DeletePrivilegeMappingCmd(privilegeId, null, groupId));
    }

    public List<PrivilegeMapping> getPrivilegeMappingsByPrivilegeId(String privilegeId) {
        return this.commandExecutor.execute(new GetPrivilegeMappingsByPrivilegeIdCmd(privilegeId));
    }

    public void deletePrivilege(String id) {
        this.commandExecutor.execute(new DeletePrivilegeCmd(id));
    }

    public PrivilegeQuery createPrivilegeQuery() {
        return this.commandExecutor.execute(new CreatePrivilegeQueryCmd());
    }

    public List<Group> getGroupsWithPrivilege(String name) {
        return this.commandExecutor.execute(new GetGroupsWithPrivilegeCmd(name));
    }

    public List<User> getUsersWithPrivilege(String name) {
        return this.commandExecutor.execute(new GetUsersWithPrivilegeCmd(name));
    }
}

