/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.impl.interceptor.Command;
import org.flowable.idm.engine.impl.interceptor.CommandContext;

public class GetUserPictureCmd
implements Command<Picture>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public GetUserPictureCmd(String userId) {
        this.userId = userId;
    }

    @Override
    public Picture execute(CommandContext commandContext) {
        if (this.userId == null) {
            throw new FlowableIllegalArgumentException("userId is null");
        }
        User user = (User)commandContext.getIdmEngineConfiguration().getIdmIdentityService().createUserQuery().userId(this.userId).singleResult();
        if (user == null) {
            throw new FlowableObjectNotFoundException("user " + this.userId + " doesn't exist", User.class);
        }
        return commandContext.getUserEntityManager().getUserPicture(user);
    }
}

