/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.rest.service.api.group;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.idm.api.Group;
import org.flowable.idm.rest.service.api.group.BaseGroupResource;
import org.flowable.idm.rest.service.api.group.GroupRequest;
import org.flowable.idm.rest.service.api.group.GroupResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Groups"}, description="Manage Groups", authorizations={@Authorization(value="basicAuth")})
public class GroupResource
extends BaseGroupResource {
    @ApiOperation(value="Get a single group", tags={"Groups"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the group exists and is returned."), @ApiResponse(code=404, message="Indicates the requested group does not exist.")})
    @GetMapping(value={"/groups/{groupId}"}, produces={"application/json"})
    public GroupResponse getGroup(@ApiParam(name="groupId") @PathVariable String groupId, HttpServletRequest request) {
        return this.restResponseFactory.createGroupResponse(this.getGroupFromRequest(groupId));
    }

    @ApiOperation(value="Update a group", tags={"Groups"}, notes="All request values are optional. For example, you can only include the name attribute in the request body JSON-object, only updating the name of the group, leaving all other fields unaffected. When an attribute is explicitly included and is set to null, the group-value will be updated to null.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the group was updated."), @ApiResponse(code=404, message="Indicates the requested group was not found."), @ApiResponse(code=409, message="Indicates the requested group was updated simultaneously.")})
    @PutMapping(value={"/groups/{groupId}"}, produces={"application/json"})
    public GroupResponse updateGroup(@ApiParam(name="groupId") @PathVariable String groupId, @RequestBody GroupRequest groupRequest, HttpServletRequest request) {
        Group group = this.getGroupFromRequest(groupId);
        if (groupRequest.getId() == null || groupRequest.getId().equals(group.getId())) {
            if (groupRequest.isNameChanged()) {
                group.setName(groupRequest.getName());
            }
            if (groupRequest.isTypeChanged()) {
                group.setType(groupRequest.getType());
            }
        } else {
            throw new FlowableIllegalArgumentException("Key provided in request body doesn't match the key in the resource URL.");
        }
        this.identityService.saveGroup(group);
        return this.restResponseFactory.createGroupResponse(group);
    }

    @ApiOperation(value="Delete a group", tags={"Groups"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the group was found and  has been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested group does not exist.")})
    @DeleteMapping(value={"/groups/{groupId}"})
    public void deleteGroup(@ApiParam(name="groupId") @PathVariable String groupId, HttpServletResponse response) {
        Group group = this.getGroupFromRequest(groupId);
        this.identityService.deleteGroup(group.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

