/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.rest.service.api.managemet;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.EngineInfo;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngines;
import org.flowable.idm.rest.service.api.managemet.IdmEngineInfoResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Engine"}, description="Manage IDM Engine", authorizations={@Authorization(value="basicAuth")})
public class IdmEngineResource {
    @ApiOperation(value="Get IDM engine info", tags={"Engine"}, notes="Returns a read-only view of the engine that is used in this REST-service.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the engine info is returned.")})
    @GetMapping(value={"/idm-management/engine"}, produces={"application/json"})
    public IdmEngineInfoResponse getEngineInfo() {
        IdmEngineInfoResponse response = new IdmEngineInfoResponse();
        try {
            IdmEngine idmEngine = IdmEngines.getDefaultIdmEngine();
            EngineInfo idmEngineInfo = IdmEngines.getIdmEngineInfo((String)idmEngine.getName());
            if (idmEngineInfo != null) {
                response.setName(idmEngineInfo.getName());
                response.setResourceUrl(idmEngineInfo.getResourceUrl());
                response.setException(idmEngineInfo.getException());
            } else {
                response.setName(idmEngine.getName());
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error retrieving idm engine info", (Throwable)e);
        }
        response.setVersion("6.3.1.0");
        return response;
    }
}

