/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.cfg.TransactionContext;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.common.engine.impl.interceptor.Session;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.history.async.AsyncHistoryDateUtil;
import org.flowable.job.service.impl.history.async.AsyncHistoryListener;
import org.flowable.job.service.impl.history.async.AsyncHistorySessionCommandContextCloseListener;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class AsyncHistorySession
implements Session {
    public static final String TIMESTAMP = "__timeStamp";
    protected CommandContext commandContext;
    protected AsyncHistoryListener asyncHistoryListener;
    protected CommandContextCloseListener commandContextCloseListener;
    protected List<String> jobDataTypes;
    protected TransactionContext transactionContext;
    protected String tenantId;
    protected Map<String, List<Map<String, String>>> jobData;

    public AsyncHistorySession(CommandContext commandContext, AsyncHistoryListener asyncHistoryJobListener) {
        this.commandContext = commandContext;
        this.asyncHistoryListener = asyncHistoryJobListener;
        this.initCommandContextCloseListener();
        if (this.isAsyncHistoryExecutorEnabled()) {
            this.transactionContext = Context.getTransactionContext();
        }
    }

    public AsyncHistorySession(CommandContext commandContext, AsyncHistoryListener asyncHistoryJobListener, List<String> jobDataTypes) {
        this(commandContext, asyncHistoryJobListener);
        this.jobDataTypes = jobDataTypes;
    }

    protected boolean isAsyncHistoryExecutorEnabled() {
        AsyncExecutor asyncHistoryExecutor = CommandContextUtil.getJobServiceConfiguration(this.commandContext).getAsyncHistoryExecutor();
        return asyncHistoryExecutor != null && asyncHistoryExecutor.isActive();
    }

    protected void initCommandContextCloseListener() {
        this.commandContextCloseListener = new AsyncHistorySessionCommandContextCloseListener(this, this.asyncHistoryListener);
    }

    public void addHistoricData(String type, Map<String, String> data) {
        this.addHistoricData(type, data, null);
    }

    public void addHistoricData(String type, Map<String, String> data, String tenantId) {
        data.put(TIMESTAMP, AsyncHistoryDateUtil.formatDate(CommandContextUtil.getJobServiceConfiguration(this.commandContext).getClock().getCurrentTime()));
        if (this.jobData == null) {
            this.jobData = new LinkedHashMap<String, List<Map<String, String>>>();
            this.commandContext.addCloseListener(this.commandContextCloseListener);
        }
        if (tenantId != null) {
            this.tenantId = tenantId;
        }
        if (!this.jobData.containsKey(type)) {
            this.jobData.put(type, new ArrayList(1));
        }
        this.jobData.get(type).add(data);
    }

    public void flush() {
    }

    public void close() {
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Map<String, List<Map<String, String>>> getJobData() {
        return this.jobData;
    }

    public void setJobData(Map<String, List<Map<String, String>>> jobData) {
        this.jobData = jobData;
    }

    public List<String> getJobDataTypes() {
        return this.jobDataTypes;
    }

    public void setJobDataTypes(List<String> jobDataTypes) {
        this.jobDataTypes = jobDataTypes;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }
}

