/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;

public class CallActivityJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        CallActivityJsonConverter.fillJsonTypes(convertersToBpmnMap);
        CallActivityJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CallActivity", CallActivityJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(CallActivity.class, CallActivityJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "CallActivity";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        CallActivity callActivity = (CallActivity)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            propertiesNode.put("callactivitycalledelement", callActivity.getCalledElement());
        }
        this.addJsonParameters("callactivityinparameters", "inParameters", callActivity.getInParameters(), propertiesNode);
        this.addJsonParameters("callactivityoutparameters", "outParameters", callActivity.getOutParameters(), propertiesNode);
    }

    private void addJsonParameters(String propertyName, String valueName, List<IOParameter> parameterList, ObjectNode propertiesNode) {
        ObjectNode parametersNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (IOParameter parameter : parameterList) {
            ObjectNode parameterItemNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSource())) {
                parameterItemNode.put("source", parameter.getSource());
            } else {
                parameterItemNode.putNull("source");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getTarget())) {
                parameterItemNode.put("target", parameter.getTarget());
            } else {
                parameterItemNode.putNull("target");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression())) {
                parameterItemNode.put("sourceExpression", parameter.getSourceExpression());
            } else {
                parameterItemNode.putNull("sourceExpression");
            }
            itemsNode.add((JsonNode)parameterItemNode);
        }
        parametersNode.set(valueName, (JsonNode)itemsNode);
        propertiesNode.set(propertyName, (JsonNode)parametersNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        CallActivity callActivity = new CallActivity();
        if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("callactivitycalledelement", elementNode))) {
            callActivity.setCalledElement(this.getPropertyValueAsString("callactivitycalledelement", elementNode));
        }
        callActivity.getInParameters().addAll(this.convertToIOParameters("callactivityinparameters", "inParameters", elementNode));
        callActivity.getOutParameters().addAll(this.convertToIOParameters("callactivityoutparameters", "outParameters", elementNode));
        return callActivity;
    }

    private List<IOParameter> convertToIOParameters(String propertyName, String valueName, JsonNode elementNode) {
        JsonNode itemsArrayNode;
        ArrayList<IOParameter> ioParameters = new ArrayList<IOParameter>();
        JsonNode parametersNode = this.getProperty(propertyName, elementNode);
        if (parametersNode != null && (itemsArrayNode = (parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)).get(valueName)) != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                JsonNode sourceNode = itemNode.get("source");
                JsonNode sourceExpressionNode = itemNode.get("sourceExpression");
                if ((sourceNode == null || !StringUtils.isNotEmpty((CharSequence)sourceNode.asText())) && (sourceExpressionNode == null || !StringUtils.isNotEmpty((CharSequence)sourceExpressionNode.asText()))) continue;
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("source", itemNode))) {
                    parameter.setSource(this.getValueAsString("source", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("sourceExpression", itemNode))) {
                    parameter.setSourceExpression(this.getValueAsString("sourceExpression", itemNode));
                }
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("target", itemNode))) {
                    parameter.setTarget(this.getValueAsString("target", itemNode));
                }
                ioParameters.add(parameter);
            }
        }
        return ioParameters;
    }
}

