/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;

public class HttpTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        HttpTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        HttpTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("HttpTask", HttpTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "HttpTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        ServiceTask task = new ServiceTask();
        task.setType("http");
        this.addField("requestMethod", "httptaskrequestmethod", elementNode, task);
        this.addField("requestUrl", "httptaskrequesturl", elementNode, task);
        this.addField("requestHeaders", "httptaskrequestheaders", elementNode, task);
        this.addField("requestBody", "httptaskrequestbody", elementNode, task);
        this.addField("requestTimeout", "httptaskrequesttimeout", elementNode, task);
        this.addField("disallowRedirects", "httptaskdisallowredirects", elementNode, task);
        this.addField("failStatusCodes", "httptaskfailstatuscodes", elementNode, task);
        this.addField("handleStatusCodes", "httptaskhandlestatuscodes", elementNode, task);
        this.addField("responseVariableName", "httptaskresponsevariablename", elementNode, task);
        this.addField("ignoreException", "httptaskignoreexception", elementNode, task);
        this.addField("saveRequestVariables", "httptasksaverequestvariables", elementNode, task);
        this.addField("saveResponseParameters", "httptasksaveresponseparameters", elementNode, task);
        this.addField("resultVariablePrefix", "httptaskresultvariableprefix", elementNode, task);
        return task;
    }
}

