/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.flowable.bpmn.model.AdhocSubProcess;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.DecisionTableAwareConverter;
import org.flowable.editor.language.json.converter.DecisionTableKeyAwareConverter;
import org.flowable.editor.language.json.converter.FormAwareConverter;
import org.flowable.editor.language.json.converter.FormKeyAwareConverter;
import org.flowable.editor.language.json.model.ModelInfo;

public class AdhocSubProcessJsonConverter
extends BaseBpmnJsonConverter
implements FormAwareConverter,
FormKeyAwareConverter,
DecisionTableAwareConverter,
DecisionTableKeyAwareConverter {
    protected Map<String, String> formMap;
    protected Map<String, ModelInfo> formKeyMap;
    protected Map<String, String> decisionTableMap;
    protected Map<String, ModelInfo> decisionTableKeyMap;

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        AdhocSubProcessJsonConverter.fillJsonTypes(convertersToBpmnMap);
        AdhocSubProcessJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("AdhocSubProcess", AdhocSubProcessJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(AdhocSubProcess.class, AdhocSubProcessJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "AdhocSubProcess";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        AdhocSubProcess subProcess = (AdhocSubProcess)baseElement;
        propertiesNode.put("completioncondition", subProcess.getCompletionCondition());
        propertiesNode.put("ordering", subProcess.getOrdering());
        propertiesNode.put("cancelremaininginstances", subProcess.isCancelRemainingInstances());
        ArrayNode subProcessShapesArrayNode = this.objectMapper.createArrayNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(subProcess.getId());
        this.processor.processFlowElements((FlowElementsContainer)subProcess, this.model, subProcessShapesArrayNode, this.formKeyMap, this.decisionTableKeyMap, graphicInfo.getX(), graphicInfo.getY());
        this.flowElementNode.set("childShapes", (JsonNode)subProcessShapesArrayNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        AdhocSubProcess subProcess = new AdhocSubProcess();
        subProcess.setCompletionCondition(this.getPropertyValueAsString("completioncondition", elementNode));
        subProcess.setOrdering(this.getPropertyValueAsString("ordering", elementNode));
        subProcess.setCancelRemainingInstances(this.getPropertyValueAsBoolean("cancelremaininginstances", elementNode));
        JsonNode childShapesArray = elementNode.get("childShapes");
        this.processor.processJsonElements(childShapesArray, modelNode, (BaseElement)subProcess, shapeMap, this.formMap, this.decisionTableMap, this.model);
        return subProcess;
    }

    @Override
    public void setFormMap(Map<String, String> formMap) {
        this.formMap = formMap;
    }

    @Override
    public void setFormKeyMap(Map<String, ModelInfo> formKeyMap) {
        this.formKeyMap = formKeyMap;
    }

    @Override
    public void setDecisionTableMap(Map<String, String> decisionTableMap) {
        this.decisionTableMap = decisionTableMap;
    }

    @Override
    public void setDecisionTableKeyMap(Map<String, ModelInfo> decisionTableKeyMap) {
        this.decisionTableKeyMap = decisionTableKeyMap;
    }
}

