/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.security;

import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.IdentityService;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.Privilege;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class BasicAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    protected IdentityService identityService;
    @Autowired
    protected IdmIdentityService idmIdentityService;
    protected boolean verifyRestApiPrivilege;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String password;
        String userId = authentication.getName();
        boolean authenticated = this.idmIdentityService.checkPassword(userId, password = authentication.getCredentials().toString());
        if (authenticated) {
            ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>(1);
            if (this.isVerifyRestApiPrivilege()) {
                List privileges = this.idmIdentityService.createPrivilegeQuery().userId(userId).list();
                for (Privilege privilege : privileges) {
                    grantedAuthorities.add(new SimpleGrantedAuthority(privilege.getName()));
                }
            } else {
                grantedAuthorities.add(new SimpleGrantedAuthority("access-rest-api"));
            }
            this.identityService.setAuthenticatedUserId(userId);
            return new UsernamePasswordAuthenticationToken((Object)userId, (Object)password, grantedAuthorities);
        }
        throw new BadCredentialsException("Authentication failed for this username and password");
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    public boolean isVerifyRestApiPrivilege() {
        return this.verifyRestApiPrivilege;
    }

    public void setVerifyRestApiPrivilege(boolean verifyRestApiPrivilege) {
        this.verifyRestApiPrivilege = verifyRestApiPrivilege;
    }
}

