/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.EventSubscription;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.runtime.process.EventSubscriptionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Event subscriptions"}, description="Manage event subscriptions", authorizations={@Authorization(value="basicAuth")})
public class EventSubscriptionResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RuntimeService runtimeService;

    @ApiOperation(value="Get a single event subscription", tags={"Event subscriptions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the event subscription exists and is returned."), @ApiResponse(code=404, message="Indicates the requested event subscription does not exist.")})
    @GetMapping(value={"/runtime/event-subscriptions/{eventSubscriptionId}"}, produces={"application/json"})
    public EventSubscriptionResponse getEventSubscription(@ApiParam(name="eventSubscriptionId") @PathVariable String eventSubscriptionId, HttpServletRequest request) {
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().id(eventSubscriptionId).singleResult();
        if (eventSubscription == null) {
            throw new FlowableObjectNotFoundException("Could not find a event subscription with id '" + eventSubscriptionId + "'.", EventSubscription.class);
        }
        return this.restResponseFactory.createEventSubscriptionResponse(eventSubscription);
    }
}

