/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.model.runtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import org.flowable.app.model.common.AbstractRepresentation;
import org.flowable.app.model.component.SimpleContentTypeMapper;
import org.flowable.content.api.ContentItem;

public class ContentItemRepresentation
extends AbstractRepresentation {
    protected String id;
    protected String name;
    protected boolean contentAvailable;
    protected String contentStoreId;
    protected String contentStoreName;
    protected String mimeType;
    protected String simpleType;
    protected Date created;
    protected String createdBy;

    public ContentItemRepresentation() {
    }

    public ContentItemRepresentation(ContentItem content, SimpleContentTypeMapper mapper) {
        this.id = content.getId();
        this.name = content.getName();
        this.contentStoreId = content.getContentStoreId();
        this.contentStoreName = content.getContentStoreName();
        this.created = content.getCreated();
        this.createdBy = content.getCreatedBy();
        this.contentAvailable = content.isContentAvailable();
        this.mimeType = content.getMimeType();
        if (mapper != null) {
            this.simpleType = mapper.getSimpleType(content);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public boolean isContentAvailable() {
        return this.contentAvailable;
    }

    public void setContentAvailable(boolean contentAvailable) {
        this.contentAvailable = contentAvailable;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getContentStoreId() {
        return this.contentStoreId;
    }

    public void setContentStoreId(String contentStoreId) {
        this.contentStoreId = contentStoreId;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getContentStoreName() {
        return this.contentStoreName;
    }

    public void setContentStoreName(String contentStoreName) {
        this.contentStoreName = contentStoreName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(String simpleType) {
        this.simpleType = simpleType;
    }
}

