/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.model.runtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.List;
import org.flowable.app.model.common.AbstractRepresentation;
import org.flowable.app.model.common.UserRepresentation;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.task.Task;
import org.flowable.engine.task.TaskInfo;

public class TaskRepresentation
extends AbstractRepresentation {
    protected String id;
    protected String name;
    protected String description;
    protected String category;
    protected UserRepresentation assignee;
    protected Date created;
    protected Date dueDate;
    protected Date endDate;
    protected Long duration;
    protected Integer priority;
    protected String processInstanceId;
    protected String processInstanceName;
    protected String processDefinitionId;
    protected String processDefinitionName;
    protected String processDefinitionDescription;
    protected String processDefinitionKey;
    protected String processDefinitionCategory;
    protected int processDefinitionVersion;
    protected String processDefinitionDeploymentId;
    protected String formKey;
    protected String processInstanceStartUserId;
    protected boolean initiatorCanCompleteTask;
    protected boolean isMemberOfCandidateGroup;
    protected boolean isMemberOfCandidateUsers;
    @JsonDeserialize(contentAs=UserRepresentation.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<UserRepresentation> involvedPeople;

    public TaskRepresentation() {
    }

    public TaskRepresentation(Task task) {
        this((TaskInfo)task, null);
    }

    public TaskRepresentation(HistoricTaskInstance task) {
        this((TaskInfo)task, null);
    }

    public TaskRepresentation(TaskInfo taskInfo, ProcessDefinition processDefinition) {
        this.id = taskInfo.getId();
        this.name = taskInfo.getName();
        this.description = taskInfo.getDescription();
        this.category = taskInfo.getCategory();
        this.created = taskInfo.getCreateTime();
        this.dueDate = taskInfo.getDueDate();
        this.priority = taskInfo.getPriority();
        this.processInstanceId = taskInfo.getProcessInstanceId();
        this.processDefinitionId = taskInfo.getProcessDefinitionId();
        if (taskInfo instanceof HistoricTaskInstance) {
            this.endDate = ((HistoricTaskInstance)taskInfo).getEndTime();
            this.formKey = taskInfo.getFormKey();
            this.duration = ((HistoricTaskInstance)taskInfo).getDurationInMillis();
        } else {
            this.formKey = taskInfo.getFormKey();
        }
        if (processDefinition != null) {
            this.processDefinitionName = processDefinition.getName();
            this.processDefinitionDescription = processDefinition.getDescription();
            this.processDefinitionKey = processDefinition.getKey();
            this.processDefinitionCategory = processDefinition.getCategory();
            this.processDefinitionVersion = processDefinition.getVersion();
            this.processDefinitionDeploymentId = processDefinition.getDeploymentId();
        }
    }

    public TaskRepresentation(TaskInfo taskInfo, ProcessDefinition processDefinition, String processInstanceName) {
        this(taskInfo, processDefinition);
        this.processInstanceName = processInstanceName;
    }

    public void fillTask(Task task) {
        task.setName(this.name);
        task.setDescription(this.description);
        if (this.assignee != null && this.assignee.getId() != null) {
            task.setAssignee(String.valueOf(this.assignee.getId()));
        }
        task.setDueDate(this.dueDate);
        if (this.priority != null) {
            task.setPriority(this.priority.intValue());
        }
        task.setCategory(this.category);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public UserRepresentation getAssignee() {
        return this.assignee;
    }

    public void setAssignee(UserRepresentation assignee) {
        this.assignee = assignee;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    public void setProcessInstanceName(String processInstanceName) {
        this.processInstanceName = processInstanceName;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public String getProcessDefinitionDescription() {
        return this.processDefinitionDescription;
    }

    public void setProcessDefinitionDescription(String processDefinitionDescription) {
        this.processDefinitionDescription = processDefinitionDescription;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public String getProcessDefinitionCategory() {
        return this.processDefinitionCategory;
    }

    public void setProcessDefinitionCategory(String processDefinitionCategory) {
        this.processDefinitionCategory = processDefinitionCategory;
    }

    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(int processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public String getProcessDefinitionDeploymentId() {
        return this.processDefinitionDeploymentId;
    }

    public void setProcessDefinitionDeploymentId(String processDefinitionDeploymentId) {
        this.processDefinitionDeploymentId = processDefinitionDeploymentId;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getProcessInstanceStartUserId() {
        return this.processInstanceStartUserId;
    }

    public void setProcessInstanceStartUserId(String processInstanceStartUserId) {
        this.processInstanceStartUserId = processInstanceStartUserId;
    }

    public boolean isInitiatorCanCompleteTask() {
        return this.initiatorCanCompleteTask;
    }

    public void setInitiatorCanCompleteTask(boolean initiatorCanCompleteTask) {
        this.initiatorCanCompleteTask = initiatorCanCompleteTask;
    }

    public boolean isMemberOfCandidateGroup() {
        return this.isMemberOfCandidateGroup;
    }

    public void setMemberOfCandidateGroup(boolean isMemberOfCandidateGroup) {
        this.isMemberOfCandidateGroup = isMemberOfCandidateGroup;
    }

    public boolean isMemberOfCandidateUsers() {
        return this.isMemberOfCandidateUsers;
    }

    public void setMemberOfCandidateUsers(boolean isMemberOfCandidateUsers) {
        this.isMemberOfCandidateUsers = isMemberOfCandidateUsers;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public List<UserRepresentation> getInvolvedPeople() {
        return this.involvedPeople;
    }

    public void setInvolvedPeople(List<UserRepresentation> involvedPeople) {
        this.involvedPeople = involvedPeople;
    }
}

