/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.api;

import java.util.Collection;
import org.flowable.idm.api.User;
import org.springframework.security.core.GrantedAuthority;

public interface UserCache {
    public CachedUser getUser(String var1);

    public CachedUser getUser(String var1, boolean var2, boolean var3, boolean var4);

    public void putUser(String var1, CachedUser var2);

    public void invalidate(String var1);

    public static class CachedUser {
        private Collection<GrantedAuthority> grantedAuthorities;
        private User user;
        private long lastDatabaseCheck;

        public CachedUser(User user, Collection<GrantedAuthority> grantedAuthorities) {
            this.user = user;
            this.grantedAuthorities = grantedAuthorities;
            this.lastDatabaseCheck = System.currentTimeMillis();
        }

        public User getUser() {
            return this.user;
        }

        public Collection<GrantedAuthority> getGrantedAuthorities() {
            return this.grantedAuthorities;
        }

        public long getLastDatabaseCheck() {
            return this.lastDatabaseCheck;
        }

        public void setLastDatabaseCheck(long lastDatabaseCheck) {
            this.lastDatabaseCheck = lastDatabaseCheck;
        }
    }
}

