/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.debugger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.model.debugger.BreakpointRepresentation;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.Job;
import org.flowable.engine.runtime.ProcessDebugger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class DebuggerService
implements ProcessDebugger,
ApplicationContextAware {
    protected List<BreakpointRepresentation> breakpoints = new ArrayList<BreakpointRepresentation>();
    protected ApplicationContext applicationContext;

    public void addBreakpoint(BreakpointRepresentation breakpointRepresentation) {
        assert (breakpointRepresentation != null && StringUtils.isNotBlank((CharSequence)breakpointRepresentation.getActivityId()));
        this.breakpoints.add(breakpointRepresentation);
    }

    public void removeBreakpoint(BreakpointRepresentation breakpointRepresentation) {
        assert (breakpointRepresentation != null && StringUtils.isNotBlank((CharSequence)breakpointRepresentation.getActivityId()));
        if (!this.breakpoints.remove((Object)breakpointRepresentation)) {
            throw new FlowableException("Breakpoint is not set on the activityId");
        }
    }

    public List<BreakpointRepresentation> getBreakpoints() {
        return this.breakpoints;
    }

    public Collection<String> getBrokenExecutions(String activityId, String processInstanceId) {
        List brokenJobs = this.getManagementService().createDeadLetterJobQuery().processInstanceId(processInstanceId).handlerType("breakpoint").list();
        ArrayList<String> executions = new ArrayList<String>();
        for (Job brokenJob : brokenJobs) {
            Execution brokenJobExecution = (Execution)this.getRuntimeService().createExecutionQuery().executionId(brokenJob.getExecutionId()).singleResult();
            if (!activityId.equals(brokenJobExecution.getActivityId())) continue;
            executions.add(brokenJob.getExecutionId());
        }
        return executions;
    }

    public void continueExecution(String executionId) {
        Job job = (Job)this.getManagementService().createDeadLetterJobQuery().handlerType("breakpoint").executionId(executionId).singleResult();
        if (job == null) {
            throw new FlowableException("No broken job found for execution '" + executionId + "'");
        }
        this.getManagementService().moveDeadLetterJobToExecutableJob(job.getId(), 3);
    }

    public boolean isBreakpoint(Execution execution) {
        for (BreakpointRepresentation breakpoint : this.breakpoints) {
            if (!breakpoint.getActivityId().equals(execution.getActivityId())) continue;
            if (StringUtils.isEmpty((CharSequence)breakpoint.getProcessDefinitionId())) {
                return true;
            }
            if (!Objects.equals(breakpoint.getProcessDefinitionId(), ((ExecutionEntity)execution).getProcessDefinitionId())) continue;
            return true;
        }
        return false;
    }

    protected ManagementService getManagementService() {
        return (ManagementService)this.applicationContext.getBean(ManagementService.class);
    }

    protected RuntimeService getRuntimeService() {
        return (RuntimeService)this.applicationContext.getBean(RuntimeService.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

