/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.editor.mapper;

import org.flowable.app.service.editor.mapper.AbstractInfoMapper;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.ServiceTask;

public class ServiceTaskInfoMapper
extends AbstractInfoMapper {
    @Override
    protected void mapProperties(Object element) {
        ServiceTask serviceTask = (ServiceTask)element;
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
            this.createPropertyNode("Class", serviceTask.getImplementation());
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
            this.createPropertyNode("Expression", serviceTask.getImplementation());
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) {
            this.createPropertyNode("Delegate expression", serviceTask.getImplementation());
        }
        if (serviceTask.isAsynchronous()) {
            this.createPropertyNode("Asynchronous", true);
            this.createPropertyNode("Exclusive", !serviceTask.isNotExclusive());
        }
        if ("mail".equalsIgnoreCase(serviceTask.getType())) {
            this.createPropertyNode("Type", "Mail task");
        }
        if ("http".equalsIgnoreCase(serviceTask.getType())) {
            this.createPropertyNode("Type", "Http task");
        }
        this.createPropertyNode("Result variable name", serviceTask.getResultVariableName());
        this.createFieldPropertyNodes("Field extensions", serviceTask.getFieldExtensions());
        this.createListenerPropertyNodes("Execution listeners", serviceTask.getExecutionListeners());
    }
}

