/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.runtime;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppVersionService {
    private static final Logger logger = LoggerFactory.getLogger(AppVersionService.class);
    private static final String VERSION_FILE = "/version.properties";
    private static final String TYPE = "type";
    private static final String MAJOR_VERSION = "version.major";
    private static final String MINOR_VERSION = "version.minor";
    private static final String REVISION_VERSION = "version.revision";
    private static final String EDITION = "version.edition";
    private static final String MAVEN_VERSION = "maven.version";
    private static final String GIT_VERSION = "git.version";
    private Map<String, String> versionInfo;

    public Map<String, String> getVersionInfo() {
        if (this.versionInfo == null) {
            Properties properties = new Properties();
            try {
                properties.load(this.getClass().getResourceAsStream(VERSION_FILE));
            }
            catch (IOException e) {
                logger.warn("Could not load version.properties", (Throwable)e);
            }
            HashMap<String, String> temp = new HashMap<String, String>();
            this.putIfExists(properties, TYPE, temp, TYPE);
            this.putIfExists(properties, MAJOR_VERSION, temp, "majorVersion");
            this.putIfExists(properties, MINOR_VERSION, temp, "minorVersion");
            this.putIfExists(properties, REVISION_VERSION, temp, "revisionVersion");
            this.putIfExists(properties, EDITION, temp, "edition");
            this.putIfExists(properties, MAVEN_VERSION, temp, "mavenVersion");
            this.putIfExists(properties, GIT_VERSION, temp, "gitVersion");
            this.versionInfo = temp;
        }
        return this.versionInfo;
    }

    protected void putIfExists(Properties properties, String property, Map<String, String> map, String mapKey) {
        String value = properties.getProperty(property);
        if (value != null) {
            map.put(mapKey, value);
        }
    }
}

