/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.flowable.app.model.runtime.TaskRepresentation;
import org.flowable.app.service.api.UserCache;
import org.flowable.app.service.idm.RemoteIdmService;
import org.flowable.app.service.runtime.PermissionService;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.UserTask;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricVariableInstance;
import org.flowable.engine.task.TaskInfo;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class FlowableAbstractTaskService {
    @Autowired
    protected RemoteIdmService remoteIdmService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected PermissionService permissionService;

    public void fillPermissionInformation(TaskRepresentation taskRepresentation, TaskInfo task, User currentUser) {
        HistoricProcessInstance historicProcessInstance;
        String processInstanceStartUserId = null;
        boolean initiatorCanCompleteTask = true;
        boolean isMemberOfCandidateGroup = false;
        boolean isMemberOfCandidateUsers = false;
        if (task.getProcessInstanceId() != null && (historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()) != null && StringUtils.isNotEmpty((CharSequence)historicProcessInstance.getStartUserId())) {
            processInstanceStartUserId = historicProcessInstance.getStartUserId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement flowElement = bpmnModel.getFlowElement(task.getTaskDefinitionKey());
            if (flowElement instanceof UserTask) {
                List groups;
                List processVariables;
                String value;
                UserTask userTask = (UserTask)flowElement;
                List extensionElements = (List)userTask.getExtensionElements().get("initiator-can-complete");
                if (CollectionUtils.isNotEmpty((Collection)extensionElements) && StringUtils.isNotEmpty((CharSequence)(value = ((ExtensionElement)extensionElements.get(0)).getElementText()))) {
                    initiatorCanCompleteTask = Boolean.valueOf(value);
                }
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                if ((CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups()) && userTask.getCandidateGroups().size() == 1 && ((String)userTask.getCandidateGroups().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateGroups('") || CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers()) && userTask.getCandidateUsers().size() == 1 && ((String)userTask.getCandidateUsers().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateUsers('")) && CollectionUtils.isNotEmpty((Collection)(processVariables = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(task.getProcessInstanceId()).list()))) {
                    for (HistoricVariableInstance historicVariableInstance : processVariables) {
                        variableMap.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups()) && CollectionUtils.isNotEmpty((Collection)(groups = this.remoteIdmService.getUser(currentUser.getId()).getGroups()))) {
                    ArrayList<String> groupIds = new ArrayList<String>();
                    if (userTask.getCandidateGroups().size() == 1 && ((String)userTask.getCandidateGroups().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateGroups('")) {
                        String[] groupsArray;
                        String candidateGroupString = (String)userTask.getCandidateGroups().get(0);
                        candidateGroupString = candidateGroupString.replace("${taskAssignmentBean.assignTaskToCandidateGroups('", "");
                        candidateGroupString = candidateGroupString.replace("', execution)}", "");
                        for (String group : groupsArray = candidateGroupString.split(",")) {
                            if (group.contains("field(")) {
                                String fieldCandidate = group.trim().substring(6, group.length() - 1);
                                Object fieldValue = variableMap.get(fieldCandidate);
                                if (fieldValue == null || !NumberUtils.isNumber((String)fieldValue.toString())) continue;
                                groupIds.add(fieldValue.toString());
                                continue;
                            }
                            groupIds.add(group);
                        }
                    } else {
                        groupIds.addAll(userTask.getCandidateGroups());
                    }
                    for (Group group : groups) {
                        if (!groupIds.contains(String.valueOf(group.getId()))) continue;
                        isMemberOfCandidateGroup = true;
                        break;
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers())) {
                    if (userTask.getCandidateUsers().size() == 1 && ((String)userTask.getCandidateUsers().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateUsers('")) {
                        String[] users;
                        String candidateUserString = (String)userTask.getCandidateUsers().get(0);
                        candidateUserString = candidateUserString.replace("${taskAssignmentBean.assignTaskToCandidateUsers('", "");
                        candidateUserString = candidateUserString.replace("', execution)}", "");
                        for (String user : users = candidateUserString.split(",")) {
                            if (user.contains("field(")) {
                                String fieldCandidate = user.substring(6, user.length() - 1);
                                Object fieldValue = variableMap.get(fieldCandidate);
                                if (fieldValue == null || !NumberUtils.isNumber((String)fieldValue.toString()) || !String.valueOf(currentUser.getId()).equals(fieldValue.toString())) continue;
                                isMemberOfCandidateGroup = true;
                            } else {
                                if (!user.equals(String.valueOf(currentUser.getId()))) continue;
                                isMemberOfCandidateGroup = true;
                            }
                            break;
                        }
                    } else if (userTask.getCandidateUsers().contains(String.valueOf(currentUser.getId()))) {
                        isMemberOfCandidateUsers = true;
                    }
                }
            }
        }
        taskRepresentation.setProcessInstanceStartUserId(processInstanceStartUserId);
        taskRepresentation.setInitiatorCanCompleteTask(initiatorCanCompleteTask);
        taskRepresentation.setMemberOfCandidateGroup(isMemberOfCandidateGroup);
        taskRepresentation.setMemberOfCandidateUsers(isMemberOfCandidateUsers);
    }
}

