/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.model.common.RemoteGroup;
import org.flowable.app.model.common.ResultListDataRepresentation;
import org.flowable.app.model.runtime.AppDefinitionRepresentation;
import org.flowable.app.security.SecurityUtils;
import org.flowable.app.service.exception.NotFoundException;
import org.flowable.app.service.idm.RemoteIdmService;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.app.AppModel;
import org.flowable.engine.repository.Deployment;
import org.flowable.idm.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableAppDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(FlowableAppDefinitionService.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected RemoteIdmService remoteIdmService;
    @Autowired
    protected ObjectMapper objectMapper;
    protected static final AppDefinitionRepresentation taskAppDefinitionRepresentation = AppDefinitionRepresentation.createDefaultAppDefinitionRepresentation("tasks");

    public ResultListDataRepresentation getAppDefinitions() {
        ArrayList<AppDefinitionRepresentation> resultList = new ArrayList<AppDefinitionRepresentation>();
        resultList.add(taskAppDefinitionRepresentation);
        HashMap<String, Object> deploymentMap = new HashMap<String, Object>();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        for (Object deployment : deployments) {
            if (deployment.getKey() == null) continue;
            if (!deploymentMap.containsKey(deployment.getKey())) {
                deploymentMap.put(deployment.getKey(), deployment);
                continue;
            }
            if (!((Deployment)deploymentMap.get(deployment.getKey())).getDeploymentTime().before(deployment.getDeploymentTime())) continue;
            deploymentMap.put(deployment.getKey(), deployment);
        }
        boolean appDefinitionHaveAccessControl = false;
        for (Deployment deployment : deploymentMap.values()) {
            AppDefinitionRepresentation appDefinition = this.createRepresentation(deployment);
            if (CollectionUtils.isNotEmpty(appDefinition.getUsersAccess()) || CollectionUtils.isNotEmpty(appDefinition.getGroupsAccess())) {
                appDefinitionHaveAccessControl = true;
            }
            resultList.add(appDefinition);
        }
        if (appDefinitionHaveAccessControl) {
            User currentUser = SecurityUtils.getCurrentUserObject();
            String userId = currentUser.getId();
            List<RemoteGroup> groups = this.getUserGroups(userId);
            ArrayList appDefinitionList = new ArrayList(resultList);
            resultList.clear();
            for (AppDefinitionRepresentation appDefinition : appDefinitionList) {
                if (!this.hasAppAccess(appDefinition, userId, groups)) continue;
                resultList.add(appDefinition);
            }
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        return result;
    }

    public AppDefinitionRepresentation getAppDefinition(String deploymentKey) {
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentKey(deploymentKey).latest().singleResult();
        if (deployment == null) {
            throw new NotFoundException("No app definition is found with key: " + deploymentKey);
        }
        return this.createRepresentation(deployment);
    }

    protected List<RemoteGroup> getUserGroups(String userId) {
        return this.remoteIdmService.getUser(userId).getGroups();
    }

    protected boolean hasAppAccess(AppDefinitionRepresentation appDefinition, String userId, List<RemoteGroup> groups) {
        if (CollectionUtils.isEmpty(appDefinition.getUsersAccess()) && CollectionUtils.isEmpty(appDefinition.getGroupsAccess())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(appDefinition.getUsersAccess()) && appDefinition.getUsersAccess().contains(userId)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(appDefinition.getGroupsAccess())) {
            for (String groupId : appDefinition.getGroupsAccess()) {
                for (RemoteGroup group : groups) {
                    if (!group.getId().equals(groupId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected AppDefinitionRepresentation createDefaultAppDefinition(String id) {
        AppDefinitionRepresentation app = new AppDefinitionRepresentation();
        return app;
    }

    protected AppDefinitionRepresentation createRepresentation(Deployment deployment) {
        AppDefinitionRepresentation resultAppDef = new AppDefinitionRepresentation();
        resultAppDef.setDeploymentId(deployment.getId());
        resultAppDef.setDeploymentKey(deployment.getKey());
        resultAppDef.setName(deployment.getName());
        AppModel appModel = this.repositoryService.getAppResourceModel(deployment.getId());
        resultAppDef.setTheme(appModel.getTheme());
        resultAppDef.setIcon(appModel.getIcon());
        resultAppDef.setDescription(appModel.getDescription());
        if (StringUtils.isNotEmpty((CharSequence)appModel.getUsersAccess())) {
            resultAppDef.setUsersAccess(this.convertToList(appModel.getUsersAccess()));
        }
        if (StringUtils.isNotEmpty((CharSequence)appModel.getGroupsAccess())) {
            resultAppDef.setGroupsAccess(this.convertToList(appModel.getGroupsAccess()));
        }
        return resultAppDef;
    }

    protected List<String> convertToList(String commaSeperatedString) {
        String[] stringArray;
        ArrayList<String> resultList = new ArrayList<String>();
        for (String value : stringArray = commaSeperatedString.split(",")) {
            resultList.add(value);
        }
        return resultList;
    }
}

