/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.service.runtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.model.common.ResultListDataRepresentation;
import org.flowable.app.model.runtime.CommentRepresentation;
import org.flowable.app.security.SecurityUtils;
import org.flowable.app.service.exception.BadRequestException;
import org.flowable.app.service.exception.NotFoundException;
import org.flowable.app.service.exception.NotPermittedException;
import org.flowable.app.service.runtime.PermissionService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.TaskService;
import org.flowable.engine.common.runtime.Clock;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.history.HistoricTaskInstanceQuery;
import org.flowable.engine.task.Comment;
import org.flowable.idm.api.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableCommentService {
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected Clock clock;

    public ResultListDataRepresentation getTaskComments(String taskId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.checkReadPermissionOnTask(currentUser, taskId);
        List<Comment> comments = this.getCommentsForTask(taskId);
        ArrayList<CommentRepresentation> commentList = new ArrayList<CommentRepresentation>();
        for (Comment comment : comments) {
            commentList.add(new CommentRepresentation(comment));
        }
        return new ResultListDataRepresentation(commentList);
    }

    public CommentRepresentation addTaskComment(CommentRepresentation commentRequest, String taskId) {
        if (StringUtils.isBlank((CharSequence)commentRequest.getMessage())) {
            throw new BadRequestException("Comment should not be empty");
        }
        HistoricTaskInstance task = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("No task found with id: " + taskId);
        }
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.checkReadPermissionOnTask(currentUser, taskId);
        Comment comment = this.createComment(commentRequest.getMessage(), currentUser, task.getId(), task.getProcessInstanceId());
        return new CommentRepresentation(comment);
    }

    public ResultListDataRepresentation getProcessInstanceComments(String processInstanceId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.checkReadPermissionOnProcessInstance(currentUser, processInstanceId);
        List<Comment> comments = this.getCommentsForProcessInstance(processInstanceId);
        ArrayList<CommentRepresentation> commentList = new ArrayList<CommentRepresentation>();
        for (Comment comment : comments) {
            commentList.add(new CommentRepresentation(comment));
        }
        return new ResultListDataRepresentation(commentList);
    }

    public CommentRepresentation addProcessInstanceComment(CommentRepresentation commentRequest, String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)commentRequest.getMessage())) {
            throw new BadRequestException("Comment should not be empty");
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new NotFoundException("No process instance found with id: " + processInstanceId);
        }
        User currentUser = SecurityUtils.getCurrentUserObject();
        this.checkReadPermissionOnProcessInstance(currentUser, processInstanceId);
        Comment comment = this.createComment(commentRequest.getMessage(), currentUser, processInstanceId);
        return new CommentRepresentation(comment);
    }

    public Long countCommentsForTask(String taskId) {
        return this.taskService.getTaskComments(taskId).size();
    }

    public Long countCommentsForProcessInstance(String processInstanceId) {
        return this.taskService.getProcessInstanceComments(processInstanceId).size();
    }

    public List<Comment> getCommentsForTask(String taskId) {
        return this.taskService.getTaskComments(taskId);
    }

    public List<Comment> getCommentsForProcessInstance(String processInstanceId) {
        return this.taskService.getProcessInstanceComments(processInstanceId);
    }

    public Comment createComment(String message, User createdBy, String processInstanceId) {
        return this.createComment(message, createdBy, null, processInstanceId);
    }

    public Comment createComment(String message, User createdBy, String taskId, String processInstanceId) {
        return this.taskService.addComment(taskId, processInstanceId, message);
    }

    public void deleteComment(Comment comment) {
        this.taskService.deleteComment(comment.getId());
    }

    public void deleteAllCommentsForProcessInstance(String processInstanceId) {
        this.taskService.deleteComments(null, processInstanceId);
    }

    protected void checkReadPermissionOnTask(User user, String taskId) {
        if (taskId == null) {
            throw new BadRequestException("Task id is required");
        }
        this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), taskId);
    }

    protected void checkReadPermissionOnProcessInstance(User user, String processInstanceId) {
        if (processInstanceId == null) {
            throw new BadRequestException("Process instance id is required");
        }
        if (!this.permissionService.hasReadPermissionOnProcessInstance(SecurityUtils.getCurrentUserObject(), processInstanceId)) {
            throw new NotPermittedException("You are not permitted to read process instance with id: " + processInstanceId);
        }
    }
}

